build-indep:

common_pkg = $(stub)-common
common_dir = $(CURDIR)/debian/$(common_pkg)
firm_dir = $(common_dir)/lib/firmware

install-firmware:
	dh_testdir
	dh_testroot
	dh_clean -k -p$(common_pkg)

	install -d $(firm_dir)

	cp -a ubuntu-firmware/zd1211 $(firm_dir)/
	cp -a ubuntu-firmware/acx $(firm_dir)/
	for i in ubuntu-firmware/*/[[:lower:]]*; do \
	  case $${i##*/} in \
	    zd121*) ;; \
	    *) test -f "$$i" && cp $$i "$(firm_dir)/${i##*/}";; \
	  esac; \
	done


install-indep: install-firmware

binary-indep: install-indep
	dh_testdir
	dh_testroot

	install -D -m 755 debian/lrm-manager debian/$(common_pkg)/sbin/lrm-manager
	install -D -m 644 debian/linux-restricted-modules-lpia-common.default \
		debian/$(common_pkg)/etc/default/linux-restricted-modules-lpia-common
	# This is only installed as an empty file to correct upgrades
	install -D -m 644 debian/linux-restricted-modules-lpia-common.modprobe \
		debian/$(common_pkg)/etc/modprobe.d/lrm-video

	dh_installchangelogs -i
	dh_installdocs -i
	dh_installinit -p $(common_pkg) --no-start -- start 7 S . start 1 0 6 .
	dh_compress -i
	dh_fixperms -i
	dh_installdeb -i
	dh_gencontrol -i
	dh_md5sums -i
	dh_builddeb -i
