/*name and version number:@(#)ltmodem.c	1.22*/
/*date of get: 		  11/24/03 14:46:49*/
/*date of delta:	  11/04/02 17:42:36*/
/****************************************************************
 * File :  ltmodem.c
 *
 * Copyright (C) 1999, 2000, 2001 Lucent Technologies Inc.
 * Copyright (C) 2001, 2002, 2003 Agere Systems Inc. All rights reserved.
 *
 * Description :
 * 	Contains the interface functions for Linux
 *
 *  Revision History
 *
 *  Initials           Date     Change
 *  Soumyendu Sarkar   11/03    SMP support included
 *
 ***************************************************************/

/****************************************************************
MRS changes
- support for 2.2 and 2.4 kernels in same file
- support for override vendor and device id's
- fixups to remove warnings from compile
   some return valuse not supplied. various statics removed
   in NOEEPROM ifdef to be consistent with other part
****************************************************************/
#ifndef ASMLINKAGE
#define ASMLINKAGE
#endif

#include <linux/autoconf.h>
#if FORCEMODVERSIONS
#if defined(CONFIG_MODVERSIONS) && !defined(MODVERSIONS)
#   define MODVERSIONS
#endif
#endif

#ifndef OMIT_EXPORTSYMTAB
#define EXPORT_SYMTAB 1
#endif

#if FORCEMODVERSIONS
#ifdef MODVERSIONS
#include <linux/modversions.h>
#endif
#endif
#include <linux/version.h>
#ifndef LINUX_VERSION_CODE
#error LINUX_VERSION_CODE not defined
#endif
#include <linux/config.h>
#include <linux/module.h>

#include <linux/sched.h>   // in order to get jiffies
#include <linux/param.h>   // in order to get HZ
#include <linux/pci.h>     // pci functions
#include <linux/interrupt.h> // in_interrupt macro
#include <linux/time.h>
#include <asm/io.h>
#include "linuxif.h"
#ifndef NO_EEPROM
#include <linux/ptrace.h>
#include <asm/uaccess.h>
#include <asm/signal.h>
#define __KERNEL_SYSCALLS__
#include <linux/unistd.h>
#include <linux/wait.h>
#include <linux/smp.h>
#endif
static char *modem_name = "Agere/Lucent WinModem Controller driver";
static char *modem_version = "8.31";
#ifndef NO_EEPROM
static char *envp[] = {"HOME=/", "TERM=linux", "PATH=/usr/bin:/bin", NULL};
static int errno;
extern int g_pid;
extern int call_func_state;
struct wait_queue * mdm_wait;
extern int call_func (unsigned int func);
#endif
extern int eeprom_flag;
spinlock_t modem_driver_lock = SPIN_LOCK_UNLOCKED;
#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,6,0))
static spinlock_t modem_lock = SPIN_LOCK_UNLOCKED;
#endif
 
#ifndef LT_SERIAL_MODULE
LT_SERIAL_MODULE lt_serial
#endif

int SetLtModemInterface(int state);

#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,3,1))
#include <asm/string.h>
#undef memset
void *memset(void *Hs, int Hc, size_t Hcount){
return __memset(Hs,Hc,Hcount);
}
#else
ASMLINKAGE
void *ltmodem_memset(void *p, int val, size_t cnt)
{
    return memset(p,val,cnt);
}
#endif

static struct pci_dev *dev = NULL;
struct timer_list timerList;
int (*lt_rs_interrupt)(void);

ASMLINKAGE
int lt_pcibios_read_config_word ( byte bus, byte dev_fn, byte where, word *val )
{
#if (LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,0))
	struct pci_dev *dev = pci_find_slot(bus, dev_fn); 
	return ((!dev)? PCIBIOS_DEVICE_NOT_FOUND : pci_read_config_word(dev, where, val));
#else
	return pcibios_read_config_word ( bus, dev_fn, where, val );
#endif
}

ASMLINKAGE
int lt_pcibios_read_config_byte ( byte bus, byte dev_fn, byte where, byte *val )	
{
#if (LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,0))
	struct pci_dev *dev = pci_find_slot(bus, dev_fn); 
	return ((!dev)? PCIBIOS_DEVICE_NOT_FOUND : pci_read_config_byte(dev, where, val));
#else
	return pcibios_read_config_byte ( bus, dev_fn, where, val );
#endif
}

ASMLINKAGE
int lt_pcibios_read_config_dword ( byte bus, byte dev_fn, byte where, unsigned int *val )
{
#if (LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,0))
	struct pci_dev *dev = pci_find_slot(bus, dev_fn); 
	return ((!dev)? PCIBIOS_DEVICE_NOT_FOUND : pci_read_config_dword(dev, where, val));
#else
	return pcibios_read_config_dword ( bus, dev_fn, where, val );
#endif
}

ASMLINKAGE
int lt_pcibios_write_config_word (byte bus, byte dev_fn, byte where, unsigned short val)
{
#if (LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,0))
	struct pci_dev *dev = pci_find_slot(bus, dev_fn); 
	return ((!dev)? PCIBIOS_DEVICE_NOT_FOUND : pci_write_config_word(dev, where, val));
#else
	return pcibios_write_config_word (bus, dev_fn, where, val);
#endif
}

ASMLINKAGE
byte Get_PCI_INTERRUPT_LINE ( void )
{
	return PCI_INTERRUPT_LINE;
}

ASMLINKAGE
byte Get_PCI_BASE_ADDRESS_1 ( void )
{
	return PCI_BASE_ADDRESS_1;
}

ASMLINKAGE
byte Get_PCI_BASE_ADDRESS_2 ( void )
{
	return PCI_BASE_ADDRESS_2;
}

ASMLINKAGE
dword Get_PCI_BASE_ADDRESS_IO_MASK ( void )
{
	return PCI_BASE_ADDRESS_IO_MASK;
}

ASMLINKAGE
byte Get_PCI_BASE_ADDRESS_SPACE_IO ( void )
{
	return PCI_BASE_ADDRESS_SPACE_IO;
}

ASMLINKAGE
BOOL lt_pci_present ( void )
{
#if (LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,0))
	//return pci_present ();
	return 1;
#else
	return pci_present ();
#endif
}

struct PCI_IDs {
	int vendor_id;
	int device_id_start;
	int device_id_last;
};

static struct PCI_IDs pci_ids[] = {
{0x115d, 0x0010, 0x03ff},
};

#ifdef MODULE
static int vendor_id = 0;
static int device_id = 0;

MODULE_PARM(vendor_id, "i");
MODULE_PARM_DESC(vendor_id, "Vendor ID of the Lucent Modem e.g. vendor_id=0x11c1");
MODULE_PARM(device_id, "i");
MODULE_PARM_DESC(device_id, "Device ID of the Lucent Modem e.g. device_id=0x0440");

static int Forced[4] = {-1,-1,-1,0};

MODULE_PARM(Forced, "4i");
MODULE_PARM_DESC(Forced, "Forced Irq,BaseAddress,ComAddress[,NoDetect] of the Lucent Modem e.g. Forced=3,0x130,0x2f8");

static int ignore_line_sense[4] = {0,0,0,0};
MODULE_PARM(ignore_line_sense, "4i");
MODULE_PARM_DESC(ignore_line_sense, "Disable line sense checking");
#endif

static int findpcidevicenumber = 0;

ASMLINKAGE
BOOL lt_pci_find_device ( struct lt_pci_dev_info *lt_dev, unsigned int id, unsigned int num )
{
 	int iter;
 	dev = pci_find_device ( id, num, dev );
	if ((dev) && (dev->irq))
	{
		if (findpcidevicenumber <= 0)
		{
		lt_dev->irq = dev->irq;
		lt_dev->vendor = dev->vendor;
		lt_dev->device = dev->device;
		lt_dev->devfn = dev->devfn;
		lt_dev->bus_num = dev->bus->number;
#if (LINUX_VERSION_CODE >= KERNEL_VERSION(2,4,0))
		lt_dev->subsystem_vendor = dev->subsystem_vendor;
		lt_dev->subsystem_device = dev->subsystem_device;
		for(iter=0; iter<=5; iter++)
		{
			if (dev->resource[iter].start)
				lt_dev->Base_Address[iter] = (dev->resource[iter].start | (dev->resource[iter].flags & 1));
			else
				lt_dev->Base_Address[iter] = 0;
		}
#else		
		pcibios_read_config_word(lt_dev->bus_num, lt_dev->devfn, PCI_SUBSYSTEM_VENDOR_ID, &lt_dev->subsystem_vendor);
		pcibios_read_config_word(lt_dev->bus_num, lt_dev->devfn, PCI_SUBSYSTEM_ID, &lt_dev->subsystem_device);
		for(iter=0; iter<=5; iter++)
			lt_dev->Base_Address[iter] = dev->base_address[iter];
#endif
		return TRUE;
		}
		findpcidevicenumber--;
	}
	if (id == PCI_VENDOR_ID_ATT && num == PCI_DEVICE_ID_ATT_L56XMF)
	{
		int len = sizeof(pci_ids)/sizeof(pci_ids[0]);
		int i;
		for(i=0;i<len;i++)
		{
			int devid;
			for(devid=pci_ids[i].device_id_start; 
			    devid<=pci_ids[i].device_id_last;
			    devid++)
			{
				if (pci_ids[i].vendor_id && devid)
				{
					dev = pci_find_device( pci_ids[i].vendor_id, devid, dev);
					if ((dev) && (dev->irq))
					{
						if (findpcidevicenumber <= 0)
						{
						lt_dev->irq = dev->irq;
						lt_dev->vendor = dev->vendor;
						lt_dev->device = dev->device;
						lt_dev->devfn = dev->devfn;
						lt_dev->bus_num = dev->bus->number;
#if (LINUX_VERSION_CODE >= KERNEL_VERSION(2,4,0))
						lt_dev->subsystem_vendor = dev->subsystem_vendor;
						lt_dev->subsystem_device = dev->subsystem_device;
						for(iter=0; iter<=5; iter++)
						{
							if (dev->resource[iter].start)
								lt_dev->Base_Address[iter] = (dev->resource[iter].start | (dev->resource[iter].flags & 1));
							else
								lt_dev->Base_Address[iter] = 0;
						}
#else		
						pcibios_read_config_word(lt_dev->bus_num, lt_dev->devfn, PCI_SUBSYSTEM_VENDOR_ID, &lt_dev->subsystem_vendor);
						pcibios_read_config_word(lt_dev->bus_num, lt_dev->devfn, PCI_SUBSYSTEM_ID, &lt_dev->subsystem_device);
						for(iter=0; iter<=5; iter++)
							lt_dev->Base_Address[iter] = dev->base_address[iter];
#endif
						return TRUE;
						}
						findpcidevicenumber--;
					}
				}
			}
		}
#ifdef MODULE
		if (vendor_id && device_id)
		{
			dev = pci_find_device ( vendor_id, device_id, dev );
			if ((dev) && (dev->irq))
			{
				if (findpcidevicenumber <= 0)
				{
				lt_dev->irq = dev->irq;
				lt_dev->vendor = dev->vendor;
				lt_dev->device = dev->device;
				lt_dev->devfn = dev->devfn;
				lt_dev->bus_num = dev->bus->number;
#if (LINUX_VERSION_CODE >= KERNEL_VERSION(2,4,0))
				lt_dev->subsystem_vendor = dev->subsystem_vendor;
				lt_dev->subsystem_device = dev->subsystem_device;
				for(iter=0; iter<=5; iter++)
				{
					if (dev->resource[iter].start)
						lt_dev->Base_Address[iter] = (dev->resource[iter].start | (dev->resource[iter].flags & 1));
					else
						lt_dev->Base_Address[iter] = 0;
				}
#else		
				pcibios_read_config_word(lt_dev->bus_num, lt_dev->devfn, PCI_SUBSYSTEM_VENDOR_ID, &lt_dev->subsystem_vendor);
				pcibios_read_config_word(lt_dev->bus_num, lt_dev->devfn, PCI_SUBSYSTEM_ID, &lt_dev->subsystem_device);
				for(iter=0; iter<=5; iter++)
					lt_dev->Base_Address[iter] = dev->base_address[iter];
#endif
				return TRUE;
				}
				findpcidevicenumber--;
			}
		}
#endif
	}
	return FALSE;
}

ASMLINKAGE
int x_smp_num_cpus (void)
{
#ifdef USE_MULTI_CPU_CHECK
#if (LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,0))
  if (num_online_cpus() > 0)
    return (num_online_cpus());
  else
#endif
#endif
    return 1;
}

ASMLINKAGE
byte GetIrqFromDev ( void )
{
	return (byte)dev->irq;
}

ASMLINKAGE
byte GetBusNumberFromDev ( void )
{
	return (byte)dev->bus->number ;
}

ASMLINKAGE
byte GetDevfnFromDev ( void )
{
	return (byte)dev->devfn;
}

ASMLINKAGE
word GetDeviceFromDev ( void )
{
	return dev->device;
}

ASMLINKAGE
word GetVendorFromDev ( void )
{
	return dev->vendor;
}

ASMLINKAGE
dword GetBase_addressFromDev ( int num )
{
#if (LINUX_VERSION_CODE >= KERNEL_VERSION(2,4,0))
	return (dev->resource[num].start | (dev->resource[num].flags & PCI_REGION_FLAG_MASK));
#else
	return dev->base_address[num];
#endif
}

// timer wrapper reqwuired due to asmlinkage mismatch between
// ltmdmobj and the kernel
void __timer_wrapper(unsigned long data)
{
    ((void (ASMLINKAGE *)(unsigned long))data)(0);
}

ASMLINKAGE
void lt_add_timer( void (ASMLINKAGE *timerfunction)(unsigned long) )
{
    	// agere made this jiffies+1 but causes 2.6.7 to overheat some processors
	// this effectively make it run every 100ms in 2.4
#if (LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,0))
	timerList.expires = jiffies+10;
#else
	timerList.expires = jiffies+1;
#endif
	timerList.function = __timer_wrapper;
	timerList.data = (unsigned long)timerfunction;
	add_timer(&timerList);
}

ASMLINKAGE
dword VMODEM_Get_System_Time (void)
{
	struct timeval time;
	do_gettimeofday( &time);
	return((time.tv_usec/1000)+(time.tv_sec*1000));
}

ASMLINKAGE
void lt_init_timer ( void  )
{
	init_timer(&timerList);
}

ASMLINKAGE
byte inp (word addr )
{
  return inb(addr);
}

ASMLINKAGE
void outp (word addr, byte value )
{
    outb(value, addr);
}

ASMLINKAGE
word inpw(word addr)
{
	return inw(addr);
}

ASMLINKAGE
void outpw(word addr, word value)
{
	return outw(value, addr);
}

ASMLINKAGE
dword inpd(word addr)
{
	return inl(addr);
}

ASMLINKAGE
void outpd(word addr, dword value)
{
	return outl(value, addr);
}

/****************************************************************
Routine : dp_regread
    i/o routines to talk to the hardware - called from background
*****************************************************************/
ASMLINKAGE
byte dp_regread ( byte reg )
{
	unsigned long flags;
	byte ret;
	// just in case this is called inside the interrupt
	if (x_smp_num_cpus() > 1)
	{
		spin_lock_irqsave(&modem_driver_lock, flags);
	}
	//spin_lock_irqsave(&modem_driver_lock,flags);
	ret = dp_regread_nonint (reg);
	if (x_smp_num_cpus() > 1)
	{
		spin_unlock_irqrestore(&modem_driver_lock, flags);
	}
	return ret;
}

/****************************************************************
Routine : dp_regwrite
    i/o routines to talk to the hardware - called from background
*****************************************************************/
ASMLINKAGE
void dp_regwrite ( byte reg, byte value )
{
	unsigned long flags = 0;
	// just in case this is called inside the interrupt
	if (x_smp_num_cpus() > 1)
	{
		spin_lock_irqsave(&modem_driver_lock, flags);
	}
	dp_regwrite_nonint ( reg, value ) ;
	if (x_smp_num_cpus() > 1)
	{
		spin_unlock_irqrestore(&modem_driver_lock, flags);
	}
}

/****************************************************************
Routine : x_sprintf
*****************************************************************/
ASMLINKAGE
int x_sprintf(char * buf, const char * fmt, ...)
{
	va_list args;
	int i;
	
	va_start(args, fmt);
	i=vsprintf(buf,fmt,args);
	va_end(args);
	return (i);
}

/****************************************************************
Routine : linux_debug_message
*****************************************************************/
ASMLINKAGE
void linux_debug_message ( byte *msg )
{
	printk("<1>ltmodem: %s\n",msg);
}

/****************************************************************
 override this for testing line sense
*****************************************************************/
ASMLINKAGE
byte x_input_orig( byte mode );
ASMLINKAGE
byte x_input( byte mode )
{
	byte rv;
	rv = x_input_orig( mode );
	if (ignore_line_sense)
	{
		if (mode == 0x39)
			rv = 0;
	}
	return rv;
}

#if 0
/****************************************************************
 override this for custom ati command
*****************************************************************/
void at_i()
{
	extern char * at_cmd_ptr;
	if (*at_cmd_ptr == '!')
	{
		at_cmd_ptr++;
		atparse_cmd();
	}
	else
	{
		at_i_orig();
	}
}
#endif
/****************************************************************

*****************************************************************/
ASMLINKAGE
int modemPortOpen ( void )
{
	extern ASMLINKAGE byte vxdPortOpen ( void ) ;
#ifndef NO_EEPROM
	if (call_func_state == 0)
	{
		call_func_state = 1;
		call_func(1);
	}
#endif
	return( vxdPortOpen() );
}

ASMLINKAGE
void modemPortClose ( void )
{
	extern ASMLINKAGE void vxdPortClose ( void ) ;
#ifndef NO_EEPROM
	if (call_func_state == 1)
	{
		call_func_state = 0;
		call_func(9);
	}
#endif
	vxdPortClose();
#if (LINUX_VERSION_CODE >= KERNEL_VERSION(2,4,0))
	SetLtModemInterface(0);
#endif
//	return 0;
}

extern unsigned short BaseAddress;
extern unsigned short ComAddress;
extern unsigned char Irq;

int lt_lucent_detect_modem ( void *pltmodem_res, int passnumber )
{
    	// lucent_detect_modem from ltmdmobj.o so is the linkage
	extern ASMLINKAGE int lucent_detect_modem ( void *pltmodem_res );
	int val;
	findpcidevicenumber = passnumber;
	val = (Forced[3])?1:lucent_detect_modem(pltmodem_res);
	if (!val)
	{
		printk(KERN_INFO "Detected Parameters Irq=%d BaseAddress=0x%x ComAddress=0x%x\n",
			Irq,BaseAddress,ComAddress);
		if (Forced[0]>0 && Forced[1]>0 && Forced[2]>0)
		{
			Irq = ((struct ltmodem_res*)pltmodem_res)->Irq = Forced[0];
			BaseAddress = ((struct ltmodem_res*)pltmodem_res)->BaseAddress = Forced[1];
			ComAddress = Forced[2];
			printk(KERN_INFO "Forced Parameters Irq=%d BaseAddress=0x%x ComAddress=0x%x\n",
				Irq,BaseAddress,ComAddress);
		}
	}
	else if (Forced[0]>0 && Forced[1]>0 && Forced[2]>0)
	{
		Irq = ((struct ltmodem_res*)pltmodem_res)->Irq = Forced[0];
		BaseAddress = ((struct ltmodem_res*)pltmodem_res)->BaseAddress = Forced[1];
		ComAddress = Forced[2];
		printk(KERN_INFO "Forced Parameters Irq=%d BaseAddress=0x%x ComAddress=0x%x\n",
			Irq,BaseAddress,ComAddress);
		// fake it
		val = 0;
	}
	return val;
}

int ltmodemDependency;
EXPORT_SYMBOL(ltmodemDependency);

//static 
int GetLtModemInterface(void *mdmdata)
{
	struct ltmodem_ops *lucent_modem_ops;
	extern ASMLINKAGE int lucent_detect_modem ( void *pltmodem_res );
	extern ASMLINKAGE void lucent_init_modem ( void ) ;
	extern ASMLINKAGE int read_vuart_port( int offset);
	extern ASMLINKAGE void write_vuart_port( int offset, int value);
	extern ASMLINKAGE int app_ioctl_handler ( unsigned int cmd, unsigned long arg );
	extern ASMLINKAGE byte dp_dsp_isr ( void );
	
	extern ASMLINKAGE word V16550_Read_RBR_buffer (byte *data, word size);

	lucent_modem_ops = (struct ltmodem_ops *)mdmdata;
	lucent_modem_ops->detect_modem = lt_lucent_detect_modem;
	lucent_modem_ops->init_modem = lucent_init_modem;
	lucent_modem_ops->PortOpen = modemPortOpen;
	lucent_modem_ops->PortClose = modemPortClose;
	lucent_modem_ops->read_vuart_register = read_vuart_port;
	lucent_modem_ops->write_vuart_register = write_vuart_port;
	lucent_modem_ops->app_ioctl_handler = app_ioctl_handler;
	lucent_modem_ops->dsp_isr = dp_dsp_isr;
	lucent_modem_ops->read_buffer = V16550_Read_RBR_buffer;
#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,6,0))
	lucent_modem_ops->modem_lock = &modem_lock;
#endif
	return 0;
}
EXPORT_SYMBOL(GetLtModemInterface);

//static 
int SetLtModemInterface(int state)
{
	if (state == 1)
#if (LINUX_VERSION_CODE >= KERNEL_VERSION(2,4,0))
		lt_rs_interrupt = (int (*)(void))inter_module_get(lt_rs_interruptstring);
#else
		lt_rs_interrupt = (int (*)(void))get_module_symbol(asstr(LT_SERIAL_MODULE),lt_rs_interruptstring);
#endif
	else
	{
#if (LINUX_VERSION_CODE >= KERNEL_VERSION(2,4,0))
		inter_module_put(lt_rs_interruptstring);
#endif
		lt_rs_interrupt = NULL;
	}
	if (lt_rs_interrupt == NULL)
		return (-1);
	return (0);
}
EXPORT_SYMBOL(SetLtModemInterface);

#ifdef MODULE
int init_module(void)
{
 	extern byte eeprom[];
 	printk(KERN_INFO "Loading %s version %s\n", modem_name, modem_version);
#ifndef NO_EEPROM
	eeprom_flag = 1;
	call_func_state = 0;
#else
	eeprom_flag = 0;
	eeprom[0] = LT_COUNTRY_ID;	// set the country ID for the Lucent modem
#endif
#if (LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,0))
	inter_module_register("GetLtModemInterface", THIS_MODULE, GetLtModemInterface);
	inter_module_register("SetLtModemInterface", THIS_MODULE, SetLtModemInterface);
#endif
 	return 0;
}
void cleanup_module(void)
{
	printk(KERN_INFO "Unloading %s: version %s\n", modem_name, modem_version);
#if (LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,0))
	inter_module_unregister("SetLtModemInterface");
	inter_module_unregister("GetLtModemInterface");
#endif
}
MODULE_DESCRIPTION("Agere/Lucent WinModem Controller driver");
#ifdef MODULE_LICENSE
MODULE_LICENSE("Proprietary");
#endif
#endif

#ifndef NO_EEPROM
void lin_kill(void)
{
	if (g_pid)
	{
		kill_proc(g_pid, SIGKILL,9);
		g_pid = 0;
	}
}

void lin_wake_up(void)
{
	wake_up(&mdm_wait);
}

void lin_interruptible_sleep_on( void )
{
	interruptible_sleep_on(&mdm_wait);
}
int lin_signal_pending( void )
{
	signal_pending(current);
	if(current->sigpending == 1)
		return 1;
	else
		return 0;
}

int function_1 (int (*fn)(void *), char *a)
{
	//int i;
	int pid;

	pid = kernel_thread(fn, a, 0);
	return pid;
}

//static 
int function_2 (char *p)
{
	//char *argStr;
	char* argv[] = {"",NULL};
	int err;
	int pid;

		set_fs(KERNEL_DS);
		if((pid = execve(p, argv, envp)) < 0)
		{
         		err = errno;
			return err;
		}
	return 0;
}
#else
void lin_kill(void) {}
void lin_wake_up(void) {}
void lin_interruptible_sleep_on( void ) {}
int lin_signal_pending( void ) { return 0; }
int function_1 (int (*fn)(void *), char *a) { return 0;}
int function_2 (char *p) { return 0;}
#endif
