/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package xnap.util.audio;

import java.net.*;
import java.io.*;

public class AudioPlayer
{
    protected String command;
    protected Process player = null;

    public AudioPlayer(String command) 
    {
	this.command = command;
    }

    public AudioPlayer() 
    {
	this("");
    }

    public boolean canPlay(File f)
    {
	return f.isDirectory() || f.getName().endsWith(".mp3");
    }

    public boolean play()
    {
	stop();

	String args[] = {
	    command
	};

	try {
	    player = Runtime.getRuntime().exec(args);
	} 
	catch (IOException e) {
	    return false;
	}

	return true;
    }

    public boolean play(File f)
    {
	stop();

	String args[] = {
	    command, f.getAbsolutePath()
	};

	try {
	    player = Runtime.getRuntime().exec(args);
	} 
	catch (IOException e) {
	    return false;
	}

	return true;
    }

    public boolean enqueue(File f)
    {
	String args[] = {
	    command, f.getAbsolutePath()
	};

	try {
	    player = Runtime.getRuntime().exec(args);
	} 
	catch (IOException e) {
	    return false;
	}

	return true;
    }

    public String getCommand(String command)
    {
	return command;
    }

    public void setCommand(String command)
    {
	this.command = command;
    }

    public boolean stop()
    {
	if (player != null) 
	    {
		player.destroy();
		player = null;
	    }

	return true;
    }
}
