/*
 *  Java Napster version x.yz (for current version number as well as for
 *  additional information see version.txt)
 *
 *  Previous versions of this program were written by Florian Student
 *  and Michael Ransburg available at www.weblicity.de/jnapster and
 *  http://www.tux.org/~daneel/content/projects/10.shtml respectively.
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.util;

import java.util.*;

public class PortRange {

    //--- Constant(s) ---

    public static final int MIN_PORT = 1;
    public static final int MAX_PORT = 65535;

    //--- Data field(s) ---

    private HashSet list = new HashSet();

    //--- Constructor(s) ---
    
    public PortRange(int first, int last) 
    {
	add(first, last);
    }

    public PortRange(String range)
    {
	add(range);
    }

    public PortRange()
    {
    }

    //--- Method(s) ---

    public void add(int first, int last)
    {
	for (int i = Math.max(first, MIN_PORT); i <= last && i <= MAX_PORT; 
	     i++) {
	    list.add(new Integer(i));
	}
    }

    public void add(int i)
    {
	if (i >= MIN_PORT && i <= MAX_PORT) {
	    list.add(new Integer(i));
	}
    }

    public void add(String range)
    {
	StringTokenizer t = new StringTokenizer(range, ";");
	while (t.hasMoreTokens()) {
	    String ports = t.nextToken().trim();

	    if (ports.length() == 0) {
		continue;
	    }

	    try {
		if (ports.indexOf("-") != -1) {
		    StringTokenizer u = new StringTokenizer(ports, "-");
		    if (u.countTokens() == 2) {
			add(Integer.parseInt(u.nextToken()),
			    Integer.parseInt(u.nextToken()));
		    }
		}
		else {
		    add(Integer.parseInt(ports));
		}
	    }
	    catch (NumberFormatException e) {
	    }
	}
    }

    public boolean contains(int port)
    {
	return list.contains(new Integer(port));
    }
    
    public Iterator iterator()
    {
	return list.iterator();
    }

    public IntIterator random()
    {
	ArrayList copy = new ArrayList(list);
	Collections.shuffle(copy);
	return new IntIterator(copy.iterator());
    }

    public int size()
    {
	return list.size();
    }

    public String toString()
    {
	StringBuffer sb = new StringBuffer();

	ArrayList copy = new ArrayList(list);
	Collections.sort(copy);

	int start = 0;
	int last = -1;
	for (IntIterator i = new IntIterator(copy.iterator()); i.hasNext();) {
	    int current = i.next();
	    if (last == -1) {
		start = current;
	    }
	    else if (current - last > 1) {
		sb.append(start);
		if (start != last) {
		    sb.append("-");
		    sb.append(last);
		}
		sb.append(";");
		start = current;
	    }
	    last = current;
	}

	if (last != -1) {
	    sb.append(start);
	    if (start != last) {
		sb.append("-");
		sb.append(last);
	    }
	    sb.append(";");
	}	

	return sb.toString();
    }

    //--- Inner class(es) ---

    public static class IntIterator
    {
	
	Iterator iterator;

	public IntIterator(Iterator iterator)
	{
	    this.iterator = iterator;
	}
	
	public boolean hasNext()
	{
	    return iterator.hasNext();
	}

	public int next()
	{
	    return ((Integer)iterator.next()).intValue();
	}
	
	public void remove()
	{
	    iterator.remove();
	}

    }

}

