/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.util;

public class NumberParser {

    //--- Constant(s) ---
    
    //--- Data field(s) ---

    private int compare;
    private int value;

    //--- Constructor(s) ---

    /**
     * @exception NumberFormatException
     */

    public NumberParser(String arg, int defaultCompare) 
    {
	compare = defaultCompare;

	if (arg.startsWith(">")) {
	    arg = arg.substring(1);
	    compare = SearchFilter.COMPARE_AT_LEAST;
	}
	else if (arg.startsWith("<")) {
	    arg = arg.substring(1);
	    compare = SearchFilter.COMPARE_AT_BEST;
	}
	else if (arg.startsWith("=")) {
	    arg = arg.substring(1);
	    compare = SearchFilter.COMPARE_EQUAL_TO;
	}
	
	value = Integer.parseInt(arg);
    }

    //--- Method(s) ---

    /**
     * 
     */
    public int getCompare()
    {
	return compare;
    }

    public int getValue()
    {
	return value;
    }

}
