/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.plugin.nap.gui;

import xnap.cmdl.Executer;
import xnap.gui.AbstractPanel;
import xnap.gui.XNapFrame;
import xnap.gui.event.PopupListener;
import xnap.gui.event.UserSupport;
import xnap.gui.menu.UserMenu;
import xnap.gui.table.LinkSpeedCellRenderer;
import xnap.gui.table.TableHeaderListener;
import xnap.gui.table.TimeCellRenderer;
import xnap.net.IChannel;
import xnap.net.IUser;
import xnap.net.event.ChannelEvent;
import xnap.net.event.ChannelListener;
import xnap.plugin.nap.*;
import xnap.plugin.nap.gui.table.UserStatusCellRenderer;
import xnap.plugin.nap.gui.table.WhoisTableModel;
import xnap.plugin.nap.net.GlobalUser;
import xnap.plugin.nap.net.User;
import xnap.plugin.nap.net.msg.MessageHandler;
import xnap.plugin.nap.util.NapPreferences;
import xnap.user.UserData;
import xnap.user.UserManager;

import java.awt.*;
import java.awt.event.*;
import java.io.IOException;
import java.util.*;
import javax.swing.*;
import javax.swing.table.*;

public class WhoisPanel extends AbstractPanel implements UserSupport {

    // --- Data Field(s) ---

    protected NapPreferences napPrefs = NapPreferences.getInstance();

    protected JTable jtaUsers;
    protected WhoisTableModel wtm;

    protected ClearAction acClear = new ClearAction();
    protected UpdateAction acUpdate = new UpdateAction();
    protected WhoisAction acWhois = new WhoisAction();

    //--- Constructor(s) ---
	
    public WhoisPanel()
    {
	initialize();
    }

    // --- Method(s) ---

    private void initialize()
    {
	setLayout(new BorderLayout(5, 5));

	JPanel jpUsers = new JPanel(new BorderLayout());

	// user popup
	UserMenu jm = new UserMenu(this, true);
	jm.add(acWhois);
	jm.addSeparator();

	// user table
	wtm = new WhoisTableModel();
	jtaUsers = wtm.createJTable();
	jtaUsers.addMouseListener(new PopupListener(jm));
	jtaUsers.setShowGrid(false);

	JScrollPane jspUsers = new JScrollPane(jtaUsers);
	jpUsers.add(jspUsers, BorderLayout.CENTER);

	// buttons
        JPanel jpButtons = new JPanel(new FlowLayout(FlowLayout.LEFT));
	jpButtons.add(new JButton(acUpdate));
	jpButtons.add(new JButton(acClear));
	jpUsers.add(jpButtons, BorderLayout.SOUTH);

	add(jpUsers, BorderLayout.CENTER);
    }

    /**
     * Performs a whois query.
     * @see xnap.plugin.nap.GUIPlugin
     */
    public void addUser(User u)
    {
	u.update(true);
	wtm.add(u);
    }
    
    public AbstractAction[] getActions()
    {
	return new AbstractAction[] {
	    acUpdate, acClear
	};
    }

    public IUser[] getUsers()
    {
	int[] rows = jtaUsers.getSelectedRows();
	IUser[] users = new IUser[rows.length];
	for (int i = 0; i < rows.length; i++) {
	    users[i] = wtm.get(rows[i]);
	}
	return users;
    }


    /**
     * Clears whois table.
     */
    private class ClearAction extends AbstractAction {

        public ClearAction() 
	{
            putValue(Action.NAME, Plugin.tr("Clear"));
            putValue(Action.SHORT_DESCRIPTION, Plugin.tr("Clear table"));
	    putValue(Action.SMALL_ICON, XNapFrame.getIcon("edittrash.png"));
            putValue(Action.MNEMONIC_KEY, new Integer('C'));
        }

        public void actionPerformed(ActionEvent event) 
	{
	    wtm.clear();
        }

    }

    /**
     * Updates user table.
     */
    private class UpdateAction extends AbstractAction {

        public UpdateAction() 
	{
            putValue(Action.NAME,Plugin.tr("Update"));
            putValue(Action.SHORT_DESCRIPTION,Plugin.tr("Update table"));
	    putValue(Action.SMALL_ICON, XNapFrame.getIcon("reload.png"));
            putValue(Action.MNEMONIC_KEY, new Integer('U'));
        }

        public void actionPerformed(ActionEvent event) 
	{
	    wtm.reload();
        }

    }

    /**
     * Performs whois query.
     */
    private class WhoisAction extends AbstractAction {

        public WhoisAction() 
	{
            putValue(Action.NAME, Plugin.tr("Requery Whois"));
            putValue(Action.SHORT_DESCRIPTION,Plugin.tr("Do a whois query"));
	    putValue(Action.SMALL_ICON, XNapFrame.getIcon("reload.png"));
            putValue(Action.MNEMONIC_KEY, new Integer('R'));
        }

        public void actionPerformed(ActionEvent event) 
	{
	    IUser[] users = getUsers();
	    for (int i = 0; i < users.length; i++) {
		User u = (User)users[i];
		u.update(true);
	    }
        }

    }

}


