/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.plugin.nap.gui;

import xnap.*;
import xnap.gui.*;
import xnap.plugin.nap.*;
import xnap.plugin.nap.util.*;

import java.awt.*;
import java.beans.*;
import javax.swing.*;
import javax.swing.border.TitledBorder;

public class NapPreferencesPanel extends AbstractPreferencesPanel 
    implements PropertyChangeListener {

    //--- Data Field(s) ----

    private NapPreferences napPrefs = NapPreferences.getInstance();

    private ValidatedTextField jteLocalPort;

    private JCheckBox jcAutoFetchNapigator;
    private JCheckBox jcUseAutoconnector;

    private ValidatedTextField jteMaxAutoconnectServers;
    private ValidatedTextField jteMaxSearchServers;
    private ValidatedTextField jteMaxSearchResultsPerServer;
    
    //--- Constructor(s) ---

    public NapPreferencesPanel()
    {
	setLayout(new GridBagLayout());

	// local port
	JPanel jpLocalPort = new JPanel(new GridBagLayout());
	jpLocalPort.setBorder(new TitledBorder(Plugin.tr("Local Port", 1)));
	GridBagHelper.add(jpLocalPort, Plugin.tr("If text field is disabled, check firewall settings"));
        jteLocalPort = new ValidatedTextField
	    (napPrefs.getLocalPortRange() + "", 20, 
	     ValidatedTextField.NUMBERS_INT + ";-");
        GridBagHelper.add(jpLocalPort, jteLocalPort, false);
	GridBagHelper.add(this, jpLocalPort);

	// startup
	JPanel jpStartup = new JPanel(new GridBagLayout());
	jpStartup.setBorder(new TitledBorder(Plugin.tr("Startup", 1)));
	GridBagHelper.add(this, jpStartup);

	jcAutoFetchNapigator 
	    = new JCheckBox(Plugin.tr("Download Napigator List", 1), 
                            napPrefs.getAutoFetchNapigator());
	GridBagHelper.add(jpStartup, jcAutoFetchNapigator);

	jcUseAutoconnector = new JCheckBox(Plugin.tr("Connect automatically",1),
					   napPrefs.getUseAutoconnector());
	GridBagHelper.add(jpStartup, jcUseAutoconnector);

	// autoconnector threshold
	GridBagHelper.addLabel(this, Plugin.tr("Automatically connected servers"));
	jteMaxAutoconnectServers = new ValidatedTextField
	    (napPrefs.getMaxAutoconnectServers() + "", 5,
	     ValidatedTextField.NUMBERS_INT);
	GridBagHelper.add(this, jteMaxAutoconnectServers, false);

	// max search servers
	GridBagHelper.addLabel(this, (Plugin.tr("Max Search Servers")));
	jteMaxSearchServers = new ValidatedTextField
	    (napPrefs.getMaxSearchServers() + "", 5,
	     ValidatedTextField.NUMBERS_INT);
	GridBagHelper.add(this, jteMaxSearchServers, false);

	// max search results per servers
	GridBagHelper.addLabel(this, (Plugin.tr("Max Search Results Per Server")));
	jteMaxSearchResultsPerServer = new ValidatedTextField
	    (napPrefs.getMaxSearchResultsPerServer() + "", 5,
	     ValidatedTextField.NUMBERS_INT);
	GridBagHelper.add(this, jteMaxSearchResultsPerServer, false);

	GridBagHelper.addVerticalSpacer(this);

	// enable controls
	updateFirewall();
	
	prefs.addPropertyChangeListener("firewalled", this);
    }

    //--- Method(s) ---

    public void apply()
    {
	napPrefs.setLocalPortRange(jteLocalPort.getText());

	napPrefs.setAutoFetchNapigator(jcAutoFetchNapigator.isSelected());
	napPrefs.setUseAutoconnector(jcUseAutoconnector.isSelected());

	napPrefs.setMaxAutoconnectServers
	    (jteMaxAutoconnectServers.getIntValue());
	napPrefs.setMaxSearchServers(jteMaxSearchServers.getIntValue());
	napPrefs.setMaxSearchResultsPerServer
	    (jteMaxSearchResultsPerServer.getIntValue());
    }

    public void close()
    {
	prefs.removePropertyChangeListener(this);
    }

    public void propertyChange(PropertyChangeEvent e)
    {
	updateFirewall();
    }

    protected void updateFirewall()
    {
	jteLocalPort.setEnabled(!prefs.isFirewalled());
    }

    public Icon getIcon()
    {
	return XNapFrame.getSmallIcon("network_local.png");
    }

    public String getTitle()
    {
	return "OpenNap";
    }


}
