/*
 * 03/30/2001
 *
 * PushMessage.java
 * Copyright (C) 2001 Frederik Zimmer
 * tristian@users.sourceforge.net
 * http://sourceforge.net/projects/ziga/
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package xnap.plugin.gnutella.net;

import xnap.plugin.gnutella.io.*;

import java.io.IOException;
import java.io.EOFException;


/**
 *
 * @version 0.1 04/13/2001
 * @author Frederik Zimmer
 */

public class PushMessage extends Message 
{
    private static final int PAYLOAD_LENGTH = 26;
    protected GUID serventID;
    protected int fileIndex;
    protected byte[] ip;
    protected int port;

    public PushMessage(GUID serventID, int fileIndex, byte[] ip, int port) 
    {
	super(DescriptorHeader.PUSH, PAYLOAD_LENGTH);
	this.serventID = serventID;
	this.fileIndex = fileIndex;
	this.ip = ip;
	if (port <= 0 || port > 0xFFFF) {
	    throw new IllegalArgumentException("Invalid port " + port);
	}
	this.port = port;
    }
	
    public PushMessage(DescriptorHeader header, DataInputStream in) 
	throws IOException, InvalidMessageException 
    {
	super(header);
	if (header.payloadLength != PAYLOAD_LENGTH) {
	    throw new InvalidMessageException("Payload-length too high");
	}
	read(in);
    }
	
    public void write(DataOutputStream out) 
	throws IOException 
    {
	super.write(out);
	out.write(serventID.getBytes());
	out.writeInt(fileIndex);
	out.write(ip);
	out.writeShort((short)port);
    }
	
    public void read(DataInputStream in) 
	throws IOException 
    {
	byte[] id = new byte[16];
	ip = new byte[4];
		
	in.readFully(id);
	serventID = new GUID(id);
		
	fileIndex = in.readInt();
		
	in.readFully(ip);
	port = in.readUShort();
    }
	
    public GUID getServentID() {
	return serventID;
    }
	
    public int getFileIndex() {
	return fileIndex;
    }
	
    public String getIP() {
	if (ip.length != 4) {
	    return null;
	}
	
	StringBuffer sb = new StringBuffer();
	
	sb.append(ip[0] & 0xFF);
	sb.append('.');
	sb.append(ip[1] & 0xFF);
	sb.append('.');
	sb.append(ip[2] & 0xFF);
	sb.append('.');
	sb.append(ip[3] & 0xFF);
	
	return sb.toString();
    }
	
    public int getPort() {
	return port;
    }
}
