/*
 * 09/20/2001
 *
 * ByeMessage.java
 * Copyright (C) 2001 Frederik Zimmer
 * tristian@users.sourceforge.net
 * http://sourceforge.net/projects/ziga/
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package xnap.plugin.gnutella.net;

import xnap.plugin.gnutella.io.*;

import java.io.IOException;


public class ByeMessage extends Message
{
    //--- Constant(s) ---

    private static final int PAYLOAD_LENGTH = 255;

    //--- Data field(s) ---

    protected short errorCode;
    protected String errorDescription;

    //--- Constructor(s) ---

    public ByeMessage(short errorCode, String errorDescription)
    {
	super(DescriptorHeader.BYE, errorDescription.length() + 2);
	this.errorCode = errorCode;
	this.errorDescription = errorDescription;
    }
	
    public ByeMessage(DescriptorHeader header, DataInputStream in)
	throws IOException, InvalidMessageException 
    {
	super(header);
	if (header.payloadLength != PAYLOAD_LENGTH) {
	    throw new InvalidMessageException("Payload-length too high");
	}
	read(in);
    }
	
    public void write(DataOutputStream out) throws IOException
    {
	super.write(out);
	out.writeShort(errorCode);
	out.write(errorDescription.getBytes());
	out.write(0);
	out.flush();
    }
	
    public void read(DataInputStream in) throws IOException
    {
	byte[] data = new byte[header.payloadLength-2];
		
	errorCode = in.readShort();
	in.readFully(data);
		
	errorDescription = new String(data, 0, data.length-1);
    }
	
    public short getErrorCode()
    {
	return errorCode;
    }
	
    public String getErrorDescription()
    {
	return errorDescription;
    }
}
