/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.plugin.gift.net.event.listener;

import xnap.plugin.gift.net.event.ShareItemEvent;
import xnap.plugin.gift.net.event.SharesControlEvent;

import java.util.EventListener;


/**
 * SharesEventListener
 *
 * @author <a href="mailto:tvanlessen@taval.de">Tammo van Lessen</a>
 * @version CVS $Id: SharesEventListener.java,v 1.2 2003/01/16 01:48:15 taval Exp $
 */
public interface SharesEventListener extends EventListener {
    //~ Methods ----------------------------------------------------------------

    /**
     * Gets called if a share item is received
     *
     * @param evt
     */
    void shareItemReceived(ShareItemEvent evt);

    /**
     * Gets called if shares listing is finished
     *
     * @param evt
     */
    void sharesListingFinished(SharesControlEvent evt);

    /**
     * Gets called if shares listing starts
     *
     * @param evt
     */
    void sharesListingStarted(SharesControlEvent evt);

    /**
     * Gets called if shares syncing starts
     *
     * @param evt
     */
    void sharesSyncFinished(SharesControlEvent evt);

    /**
     * Gets called if shares syncing sends a status msg
     *
     * @param evt
     */
    void sharesSyncStarted(SharesControlEvent evt);

    /**
     * Gets called if shares syncing is finished
     *
     * @param evt
     */
    void sharesSyncStatus(SharesControlEvent evt);
}
