/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.plugin.gift.net.event;

/**
 * ControlEvent
 *
 * @author <a href="mailto:tvanlessen@taval.de">Tammo van Lessen</a>
 * @version CVS $Id: ControlEvent.java,v 1.2 2003/01/16 01:48:15 taval Exp $
 */
public class ControlEvent extends Event {
    //~ Static fields/initializers ---------------------------------------------

    public static final int STARTED = 0;
    public static final int FINISHED = 1;
    public static final String[] ACTIONS = { "started", "finished" };

    //~ Instance fields --------------------------------------------------------

    private String status;
    private int action;

    //~ Constructors -----------------------------------------------------------

    /**
     * Constructor for ControlEvent.
     *
     * @param action the action
     */
    public ControlEvent(int action) {
        super();
        this.action = action;
        this.status = null;
    }

    /**
     * Creates a new ControlEvent object.
     *
     * @param action DOCUMENT ME!
     * @param status DOCUMENT ME!
     */
    public ControlEvent(int action, String status) {
        super();
        this.action = action;
        this.status = status;
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * Sets the action.
     *
     * @param action The action to set
     */
    public void setAction(int action) {
        this.action = action;
    }

    /**
     * Returns the action.
     *
     * @return int
     */
    public int getAction() {
        return action;
    }

    /**
     * Sets the status.
     *
     * @param status The status to set
     */
    public void setStatus(String status) {
        this.status = status;
    }

    /**
     * Returns the status.
     *
     * @return String
     */
    public String getStatus() {
        return status;
    }

    /**
     * @see java.lang.Object#toString()
     */
    public String toString() {
        return ACTIONS[action] + "@" + getClass().getName();
    }
}
