/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.user;

import xnap.net.IUser;

import java.io.Serializable;

public class UserData implements Serializable
{

    //--- Constant(s) ---

    //--- Data field(s) ---

    public String browseCacheFilename = "";
    public String comment = "";
    public boolean cacheBrowseResults = true;
    public long downloadBandwidth = -1;
    public boolean ignoreChat = false;

    /**
     * Downloads from this user.
     */
    public int maxDownloads = IUser.TRANSFER_DEFAULT;

    /**
     * Uploads to this user.
     */
    public int maxUploads = IUser.TRANSFER_DEFAULT;

    public String name;
    public String parentClass;
    public long uploadBandwidth = -1;

    //--- Constructor(s) ---

    public UserData(String parentClass, String name)
    {
	this.parentClass = parentClass;
	this.name = name;
    }

    //--- Method(s) ---

}
