/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package xnap.plugin.nap.net.msg.server;

import xnap.plugin.nap.net.User;
import xnap.plugin.nap.util.Channel;
import xnap.util.QuotedStringTokenizer;

public class JoinMessage extends ServerMessage {
    
    //--- Constant(s) ---
    
    public static final int TYPE = 406;
    
    //--- Data Field(s) ---
    
    public String channelName;
    public String nick;
    public int fileCount;
    public int linkSpeed;

    //--- Constructor(s) ---
    
    public JoinMessage(String data) throws InvalidMessageException
    {
	super(TYPE, data, 4);
    }

    //--- Method(s) ---

    protected void parse(QuotedStringTokenizer t)
    {
	channelName = t.nextToken();
	nick = t.nextToken();
	fileCount = Integer.parseInt(t.nextToken());
	linkSpeed = Integer.parseInt(t.nextToken());
    }

    public void received()
    {
	User u = server.getUser(nick);
	u.setFileCount(fileCount);
	u.setLinkSpeed(linkSpeed);

	Channel c = server.getChannel(channelName);
	c.add(u);
    }

}    

