/*
 *  Java Napster version x.yz (for current version number as well as for
 *  additional information see version.txt)
 *
 *  Previous versions of this program were written by Florian Student
 *  and Michael Ransburg available at www.weblicity.de/jnapster and
 *  http://www.tux.org/~daneel/content/projects/10.shtml respectively.
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.plugin.nap.net;

import xnap.io.Repository;
import xnap.io.ThrottledOutputStream;
import xnap.plugin.nap.net.msg.MessageHandler;
import xnap.plugin.nap.net.msg.client.DirectShareFileMessage;
import xnap.plugin.nap.util.NapPreferences;
import xnap.util.Preferences;
import xnap.util.Range;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import org.apache.log4j.Logger;

public class DirectBrowseUpload implements Runnable {
    
    //--- Constant(s) ---
    
    //--- Data field(s) ---

    protected static Logger logger 
	= Logger.getLogger(DirectBrowseUpload.class);

    protected Socket socket;
    protected OutputStream out;

    //--- Constructor(s) ---

    public DirectBrowseUpload(Socket socket)
    {
	this.socket = socket;
    }

    protected DirectBrowseUpload()
    {
    }

    //--- Method(s) ---

    public void close()
    {
        try {
	    if (out != null) {
		out.close();
	    }
	    if (socket != null) {
		socket.close();
	    }
        } 
	catch (IOException e) {
        }
    }

    public void run()
    {
	try {
	    out = new ThrottledOutputStream(socket.getOutputStream());

	    Server server = MessageHandler.removeBrowseRequest();
	    if (server != null) {
		write(server.getUsername() + "\n");
		//write("\n");	    
		
		if (NapPreferences.getInstance().getSendWholeRepository()) {
		    sendWholeRepository();
		}
		else {
		    sendList(server.getShared());
		}
	    }
	    else {
		write("INVALID REQUEST\n");
	    }
	}
	catch (IOException e) {
	    logger.warn("direct browse failed", e);
	}

	close();
    }

    public void start()
    {
	Thread t = new Thread(this, "DirectBrowseUpload");
	t.start();
    }

    protected void sendList(Range r) throws IOException
    {
	for (int i = (int)r.start; i <= (int)r.end; i++) {
	    File f = Repository.getInstance().getFile(i);
	    if (f != null) {
		DirectShareFileMessage msg = new DirectShareFileMessage(i, f);
		write(msg.data + "\n");
	    }
	}
	write("\n");
    }

    protected void sendWholeRepository() throws IOException
    {
	int size = Repository.getInstance().size();
	for (int i = 0; i < size; i++) {
	    File f = Repository.getInstance().getFile(i);
	    if (f != null) {
		DirectShareFileMessage msg = new DirectShareFileMessage(i, f);
		write(msg.data + "\n");
	    }
	}
	write("\n");
    }
    
    protected void write(String message) throws IOException
    {
	logger.debug("> " + message);
	out.write(message.getBytes());
	out.flush();
    }

}

