/*
 *  Java Napster version x.yz (for current version number as well as for
 *  additional information see version.txt)
 *
 *  Previous versions of this program were written by Florian Student
 *  and Michael Ransburg available at www.weblicity.de/jnapster and
 *  http://www.tux.org/~daneel/content/projects/10.shtml respectively.
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package xnap.plugin.gnutella.net;

import xnap.io.ThrottledInputStream;
import xnap.net.*;
import xnap.util.*;
import xnap.plugin.gnutella.util.*;

import HTTPClient.*;

import java.beans.*;
import java.io.*;
import java.net.*;
import java.net.URLEncoder;
import java.util.*;

public class Download extends AbstractDownload 
{
    
    // --- Constant(s) ---

    public static final int SERVENT_TIMEOUT = 30 * 1000;

    // --- Data Field(s) ---

    private SearchResult sr;
    private GnuPreferences gnuPrefs = GnuPreferences.getInstance();
    private boolean firewalled = false;

    // socket communication
    protected Socket socket;
    protected InputStream in;

    protected long offset;

    // --- Constructor(s) ---
    
    public Download(SearchResult sr)
    {
	super(sr.getUser(), sr.getFilesize());
	this.sr = sr;
    } 

    // --- Method(s) ---

    public int available() throws IOException
    {
	return in.available();
    }

    public void close()
    {
	try {
	    if (in != null)
		in.close();
	    if (socket != null)
		socket.close();
	}
	catch (IOException ie) {
	}
    }

    public int read(byte[] b) throws IOException
    {
	return in.read(b);
    }

    public boolean connect(long offset) throws IOException
    {
	this.offset = offset;
	
	start();

	if (firewalled) {
	    if (!establishReverseStream()) {
		return false;
	    }
	}

	try {
	    if (firewalled) {
		HTTPConnection con = new HTTPConnection(socket);
		NVPair headers[] = new NVPair[] {
		    new NVPair("Connection", "Keep-Alive"),
		    new NVPair("Range", "bytes=" + offset + "-")
			};
		try {
		    HTTPResponse rsp = con.Get("/get/" + sr.getIndex() + "/" 
					       + sr.getFilename(), "", headers);
		    if (rsp.getStatusCode() >= 300) {
			throw new IOException("Error " + rsp.getStatusCode());
		    }
		    else {
			in = rsp.getInputStream();
		    }
		}
		catch (ModuleException me) {
		    throw new IOException(me.getMessage());
		}
	    }
	    else {
		URL url = createRequestURL(sr);
		java.net.HttpURLConnection connection = 
		    (java.net.HttpURLConnection) url.openConnection();
		connection.setRequestProperty("Connection", "Keep-Alive");
		connection.setRequestProperty("Range", "bytes=" + offset + "-");
		connection.setRequestProperty("User-Agent", "XNap");
		
		connection.connect();
		
		if (checkStatusCode(connection.getResponseCode())) {
		    in = connection.getInputStream();
		    return true;
		}
	    }
	}
	catch (IOException ioe) {
	    Debug.log("HTTP: " + ioe);
	    throw(ioe);
	}
	return false;
    }

     private boolean establishReverseStream() 
     {
	 /* create push message */
	 Servent servent = sr.getServent();
	 String ip = servent.getLocalAddress();

	 if (ip == null) {
	     return false;
	 }

	 short port = (short) Connections.getInstance().getListenerPort();

	 if (port == 0) {
	     return false;
	 }

	 PushMessage pmsg = new PushMessage(sr.getServentID(), sr.getIndex(), 
					    IPHelper.ipStringToBytearray(ip),
					    port);
	 servent.send(pmsg, Servent.PRIORITY_NORMAL);

	 /* wait for peer to connect to listener */
	 socket = 
	     Connections.getInstance().getListener().
	     waitForDownloadSocket(sr.getIndex(), sr.getFilename(), 
				   sr.getServentID(), SERVENT_TIMEOUT);

	 if (socket == null) {
	     return false;
	 }
	 try {
	     socket.setSoTimeout(SOCKET_TIMEOUT);
	 }
	 catch (SocketException s) {
	 }

	 return true;
     }

     private boolean checkStatusCode(int status)
     {
	 Debug.log("gnutella download: check http status " + status);

	 /* only consider first digit */
	 status = status / 100;

	 switch (status) {
	 case 2:
	     return true;
	 default:
	     return false;
	 }
     }

     private URL createRequestURL(SearchResult sr) 
	 throws IOException
     {
	 URL url;
	 try {
	     return new URL("http", sr.getIP(), sr.getPort(),
			    "/get/" + sr.getIndex() + "/" + sr.getFilename());
	 }
	 catch (MalformedURLException me) {
	     throw (new IOException(me.getMessage()));
	 }
    }

}
    
