/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package xnap.net;

import xnap.*;
import xnap.net.event.*;
import xnap.util.*;

import java.util.*;

/**
 * Once die is called the runner is interrupted and the thread is doomed to 
 * die. 
 */
public abstract class AbstractRunnable extends AbstractCommunication {

    //--- Constant(s) ---

    //--- Data field(s) ---

    protected boolean die = false;
    protected String dieMessage = null;
    protected Thread runner = null;
    // FIX: maybe we should use this
    //private static ThreadLocal runnerStatus = new ThreadLocal();

    //--- Constructor(s) ---

    //--- Method(s) ---

    public String getStatusText() 
    {
	return super.getStatusText();
    }

    protected boolean canStart()
    {
	return runner == null || !runner.isAlive();
    }

    protected void die(int status, String message)
    {
	if (runner != null && runner.isAlive()) {
	    setStatus(status, XNap.tr("aborting") + "...");
	    dieMessage = message;
	    die = true;
	    runner.interrupt();
	}
	else {
	    setStatus(status, message);
	    die();
	}
    }

    protected void die(int status)
    {
	die(status, null);
    }

    /**
     * This can be ovverriden by sub classes.
     */
    protected void die()
    {
    }

    protected void died()
    {
	if (die) {
	    die = false;
	    setStatus(getStatus(), dieMessage);
	}
    }

    public boolean isAborting()
    {
	return die && runner != null && runner.isAlive();
    }

    /**
     * Sets a new status and notifies listeners.
     *
     * @param newResponse custom status message
     */
    protected void setStatus(int newValue, String newResponse)
    {
	if (isAborting()) {
	    // don't change status while thread is dying
	    return;
	}

	super.setStatus(newValue, newResponse);
    }

}
