/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package xnap.gui;

import xnap.gui.util.GUIHelper;
import xnap.util.*;

import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.text.BadLocationException;

public class ConsolePane extends JScrollPane implements PropertyChangeListener {

    //--- Constant(s) ---

    //--- Data field(s) ---

    private Preferences prefs = Preferences.getInstance();
    private JTextArea jta;
    private boolean crop;
    private boolean appendPending = false;
    private StringBuffer pendingText = new StringBuffer();

    //--- Constructor(s) ---

    public ConsolePane(boolean crop)
    {
	this.crop = crop;

	initialize();

	prefs.addFontListener("console", this);
	prefs.addColorListener("consoleBackground", this);
	prefs.addColorListener("consoleForeground", this);
    }

    public ConsolePane()
    {
	this(true);
    }
    
    //--- Method(s) ---

    public void initialize() 
    {
	jta = new JTextArea();
        jta.setLineWrap(true);
        jta.setWrapStyleWord(true);
        jta.setCaretColor(java.awt.Color.red);
	jta.setSelectedTextColor(java.awt.Color.red);
        jta.setEditable(false); 
	jta.setBorder(new EmptyBorder(5, 5, 5, 5));

	setVerticalScrollBarPolicy
	    (JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
	setHorizontalScrollBarPolicy
	    (JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);

	setViewportView(jta);
	
	updateProperties();
    }

    public void appendLater(final String text)
    {
	synchronized (pendingText) {
	    pendingText.append(text);
	    if (appendPending) {
		return;
	    }
	    appendPending = true;
	}

	Runnable r = new Runnable()
	    {
		public void run() 
		{
		    String toAppend;
		    synchronized (pendingText) {
			toAppend = pendingText.toString();
			pendingText.setLength(0);
			appendPending = false;
		    }
		    append(toAppend);
		}
	    };

	SwingUtilities.invokeLater(r);
    }

    public void append(String text) 
    {
  	JScrollBar sb = getVerticalScrollBar();
  	int pos = sb.getValue() + sb.getVisibleAmount();
	boolean autoScroll = (pos == sb.getMaximum());

//  	System.out.println("pos: " + pos);
//  	System.out.println("max: " + sb.getMaximum());

	jta.append(text);

	if (crop) {
	    //remove some lines at the top and leave maxConsoleLines
	    int i = jta.getLineCount() - prefs.getMaxConsoleLines();
	    if (i > 0) {
		try {
		    int endoffset = jta.getLineEndOffset(i);
		    jta.replaceRange(null, 0, endoffset);

		    // try to keep displaying the same text
//  		    pos = (pos >= i) ? pos - i : 0;
//  		    System.out.println("new pos: " + pos);
		}
		catch (BadLocationException e) {
		}
	    }
	}

	if (autoScroll) {
//  	    pos = (pos > jta.getLineCount() - 1) ? jta.getLineCount() - 1 : pos;
	    try {
		pos = jta.getLineCount() - 1;
//  		System.out.println("scroll to: " + pos);
		jta.setCaretPosition(jta.getLineEndOffset(pos));
	    }
	    catch (BadLocationException e) {
	    }
	}
    }

    public void propertyChange(PropertyChangeEvent e)
    {
	updateProperties();
    }

    public void setText(String newValue)
    {
	jta.setText(newValue);
    }

    public void updateProperties()
    {
	jta.setFont(GUIHelper.getFont("console"));
	jta.setBackground(GUIHelper.getColor("consoleBackground"));
	jta.setForeground(GUIHelper.getColor("consoleForeground"));
    }

}
