/*
 *  XNap
 *
 *  A pure java file sharing client.
 *
 *  See AUTHORS for copyright information.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package xnap.gui;

import xnap.XNap;
import xnap.net.IChannel;
import xnap.net.event.ChannelEvent;
import xnap.net.event.ChannelListener;
import xnap.util.ChatManager;
import xnap.util.event.ListEvent;
import xnap.util.event.ListListener;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import javax.swing.event.*;

public class ChatPanel extends AbstractPanel
    implements ListListener, ChannelListener {

    // --- Data Field(s) ---

    protected CloseableTabbedPane jtp;
    protected ChatGlobalSubPanel cspGlobal;
    protected Hashtable panelsByChannel = new Hashtable();
    protected Hashtable autoJoinPanelsByChannelName = new Hashtable();

    //--- Constructor(s) ---

    public ChatPanel() 
    {
	initialize();

	ChatManager.getInstance().getChannels().addListListener(this);
	ChatManager.getInstance().addChannelListener(this);
    }

    // --- Method(s) ---

    private void initialize()
    {
	jtp = new CloseableTabbedPane();
	jtp.addContainerListener(new TabListener());

	cspGlobal = new ChatGlobalSubPanel();
	cspGlobal.setStatusListener(this);
	jtp.addTab(XNap.tr("Global"), cspGlobal, false);
	
	setLayout(new BorderLayout());
	add(jtp, BorderLayout.CENTER);
    }

    public void addChangeListener(ChangeListener l) 
    {
	jtp.addChangeListener(l);
    }

    public void channelClosed(ChannelEvent e)
    {
    }

    public synchronized void elementAdded(final ListEvent e)
    {
	final IChannel c = (IChannel)e.getElement();
	ChatSubPanel csp;
	if (ChatManager.getInstance().isAutoJoinChannel(c)) {
	    csp = (ChatSubPanel)autoJoinPanelsByChannelName.get
			    (c.getName().toLowerCase());
	    if (csp != null) {
		csp.addChannel(c);
		panelsByChannel.put(c, csp);
		return;
	    }
	    else {
		csp = new ChatSubPanel(c);
		autoJoinPanelsByChannelName.put
		    (c.getName().toLowerCase(), csp);
	    }
	}
	else {
	    csp = new ChatSubPanel(c);
	}
	panelsByChannel.put(c, csp);
	
	final ChatSubPanel tab = csp;
 	Runnable runner = new Runnable()
 	    {
 		public void run()
 		{
		    jtp.addTab(c.getName(), tab);
		    if (!ChatManager.getInstance().isAutoJoinChannel(c)) {
			XNapFrame.setFocusTo("chat");
			if (prefs.getBlinkOnChannelJoin()) {
			    XNapFrame.getInstance().chatBlink();
			}
 		    }
 		}
 	    };
 	SwingUtilities.invokeLater(runner);
    }

    public synchronized void elementRemoved(final ListEvent e)
    {
	IChannel c = (IChannel)e.getElement();
	final ChatSubPanel csp 
	    = (ChatSubPanel)panelsByChannel.get(e.getElement());
	if (csp != null) {
	    csp.removeChannel(c);

	    if (csp.getChannelCount() == 0) {
		Runnable runner = new Runnable()
		    {
			public void run()
			{
			    jtp.remove(csp);
			}
		    };
		SwingUtilities.invokeLater(runner);
	    }
	}
    }

    public JMenu getChannelTableMenu()
    {
	return cspGlobal.getChannelTableMenu();
    }

    public Component getSelectedTab()
    {
	return jtp.getSelectedComponent();
    }

    public void messageReceived(ChannelEvent e)
    {
	cspGlobal.messageReceived(e);
    }

    public void userAdded(ChannelEvent e)
    {
    }

    public void userRemoved(ChannelEvent e)
    {
    }

    public void savePrefs()
    {
	cspGlobal.savePrefs();
    }

    public void topicChanged(ChannelEvent e)
    {
    }

    protected class TabListener extends ContainerAdapter
    {

	public void componentRemoved(ContainerEvent e)
	{
	    ChatSubPanel csp = (ChatSubPanel)e.getChild();
	    if (ChatManager.getInstance().isAutoJoinChannel(csp.getChannel())) {
		autoJoinPanelsByChannelName
		    .remove(csp.getChannel().getName().toLowerCase());
	    }

	    IChannel[] channels = csp.getChannels();
	    for (int i = 0; i < channels.length; i++) {
		// avoid double remove: we only remove the reference, 
		// the user has already removed the panel
		panelsByChannel.remove(channels[i]);

		ChatManager.getInstance().removeChannel(channels[i]);
	    }
	}

    }

}
