/*
 * VRwave.java
 * VRML 2.0 browser, written largely in Java
 *
 * created: mpichler, 19960923
 *
 * changed: kwagen, 19970830
 * changed: mpichler, 19970919
 *
 * $Id: VRwave.java,v 1.26 1997/09/29 12:53:08 mpichler Exp $
 */


package iicm.vrml.vrwave;

import iicm.ge3d.GE3D;
import vrml.external.Browser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.util.Properties;
import java.net.URL;
import java.net.MalformedURLException;

/*
 * you only need to import netscape.plugin.Plugin when you want
 * vrml.external.Browser to be derived from Plugin to use Java-EAI
 * with dirty JavaScript browser location code.
 * See javasrc/vrml/external/Browser
 */

import netscape.plugin.Plugin;


/**
 * VRwave - VRML 2.0 browser, written largely in Java.
 * Copyright (c) 1996,97 IICM
 *
 * @author Michael Pichler (lead programmer)
 * @author Karin Roschker (early version of VRML parser)
 * @author Andreas Pesendorfer (GUI, event handling)
 * @author Karl Heinz Wagenbrunn (rendering)
 * @version 0.9, latest change: 25 Sep 97
 */


public class VRwave extends java.applet.Applet
{
  Scene scene_ = null;  // applet only
  public Scene getScene ()
  {
    return scene_;
  }

  // used to parse command line options
  private final static int ARG_HELP = 1;
  private final static int ARG_URL = 2;
  private final static int ARG_VERBOSE = 3;
  private final static int ARG_NOASMOOTH = 4;
  private final static int ARG_NOCONVEXIFY = 5;
  private final static int ARG_LANG = 6;
  private final static int ARG_HELPURL = 7;
  private final static int ARG_BACKGRD3D = 8;
  private final static int ARG_DRAWMODE = 9;
  private final static int ARG_INTDRAW = 10;
  private final static int ARG_CACHEPROXY = 11;
  private final static int ARG_FIREWALL = 12;
  private final static int ARG_HOME = 13;
  private final static int ARG_NOICONIMAGES = 14;

  // the following two arrays must have consistent entries
  private final static String[] ARGOPTIONS =
  {
    "-h", "-help",
    "-verbose", "-lang",
    "-URL", "-home", "-helpURL",
    "-bg3d", "-drawmode", "-intdraw",
    "-proxy", "-firewall",
    "-noasmooth", "-noconvexify", "-noicons"
  };
  private final static int[] ARGTAGS =
  {
    ARG_HELP, ARG_HELP,
    ARG_VERBOSE, ARG_LANG,
    ARG_URL, ARG_HOME, ARG_HELPURL,
    ARG_BACKGRD3D, ARG_DRAWMODE, ARG_INTDRAW,
    ARG_CACHEPROXY, ARG_FIREWALL,
    ARG_NOASMOOTH, ARG_NOCONVEXIFY, ARG_NOICONIMAGES
  };

  final static public String NAME = "VRwave";
  final static public String VERSION = "0.9";
  final static String DATE = "Sep 29, 1997";
  final static String HOMEURL = "http:/"+"/www.iicm.edu/vrwave";

  private final static String USAGE =
    "usage: vrwave [Options] [File]\n\n" +
    "specify \"-\" as File to read from standard input\n\n" +
    "Options:\n" +
    "  -h, -help      print this usage help\n" +
    "  -verbose       verbose output (window creation etc.)\n" +
    "  -lang lg       language: [english|german|french|italian|spanish|styrian]\n" +
    "  -URL url       base URL for relative references\n" +
    "                 or read directly from URL when no File given\n" +
//    "  -props loc     property (preferences) location/filename\n" +  // TODO
    "  -home path     VRwave \"home\" directory or URL (to locate icons)\n" +  // later for fonts too
    "  -helpURL url   base URL for online help\n" +
    "  -bg3d #rrggbb  scene area background color (#000000 to #ffffff)\n" +
    "  -drawmode m    drawing mode: [wireframe|hiddenline|flat|smooth|texturing]\n" +
    "  -intdraw m     interactive drawing mode: one of the above or \"same\"\n" +
    "  -proxy host:p  proxy host and port no.\n" +
    "  -firewall h:p  firewall host and port no.\n";
  // undocumented (debugging purposes only):
  // -noasmooth, -noconvexify, -noicons

  public final static String STARTUP =
    "\n--- VRwave " + VERSION + " of " + DATE + " ---\n" +
    "Copyright (c) 1997 IICM, Graz University of Technology, Austria.\n";

  /**
   * verbose flag
   */

  static boolean verbose = false;

  static boolean asmooth = true;
  static boolean convexify = true;
  static boolean iconimages = true;


  /**
   * Applet version (for running with appletviewer or netscape)
   */

  public void init ()
  {
    System.out.println (STARTUP);
    setLayout (new BorderLayout ());

    if (new Boolean (getParameter ("verbose")).booleanValue ())  // non-null and "true"
      verbose = true;

    scene_ = new Scene (this);
    // scene_.readScene (getParameter ("fileName"));  // applets not allowed to read local files
    String url = getParameter ("sceneURL");
    try
    {
      // System.out.println ("scene URL: " + url);
      // System.out.println ("relative to document base: " + getDocumentBase ());
      scene_.readScene (new URL (getDocumentBase (), url));  // relative to document base
      add ("Center", new SceneCanvas (getParameter ("windowTitle"), scene_));
      // menu toolbox
      new SceneFrame ("VRwave", scene_, false);  // shows itself
    }
    catch (MalformedURLException e)
    {
      System.err.println ("VRwave: invalid or missing sceneURL parameter <" + url + ">");
    }
  } // init Applet

  public void start ()  // Applet start
  {
    try
    { Browser.startVRwave (scene_);
    }
    catch (Throwable e)
    { System.out.println ("wrong or missing Browser class, won't get EAI connection.");
    }
  }

  public void stop ()  // Applet stop
  {
    try
    { Browser.stopVRwave (scene_);
    }
    catch (Throwable e)
    { System.out.println ("wrong or missing Browser class, won't get EAI connection.");
    }
  }


  // from commandline
  static String filename_ = null;
  static String baseurl_ = null;
  static String home_ = null;
  static String helpurl_ = "file:/no/help/w/o/helpURL/";

  // VRWAVE_HOME - used to search icons.gif (and fonts in future versions)
  static public void setHome (String home)
  {
    // this was intended to show icons for VRwave Plug-In. Does not work because
    // netscape is not willing to serve Java URL requests while in NPP_New
    // home_ = home;
    // HELP menu items wont work. TODO: callback mechanism to VRwavePlugin to fetch
    // URLs via netscape plugin mechanism
    helpurl_ = home + "/help/";
  }


  /**
   * Application Version (for running with java)
   */

  public static void main (String[] args)
  {
    System.out.println (STARTUP);

    // declare VRwave version in HTTP requests
    Properties props = System.getProperties ();
    props.put ("http.agent", "VRwave/" + VERSION);  // User-Agent

    Scene scene = new Scene (null);

    parseCommandline (args, scene, props);

    // set properties
    System.setProperties (props);

    if (filename_ != null)  // read from file
    {
      if (filename_.equals ("-"))  // read from std. input
        scene.readScene (System.in, baseurl_, "<stdin>");
      else
        scene.readScene (filename_, baseurl_);  // baseurl_ may be null
    }
    else if (baseurl_ != null)  // read from URL
    {
      try
      {
        scene.readScene (new URL (baseurl_));
      } catch (MalformedURLException e)
      {
        System.out.println ("invalid URL <" + baseurl_ + ">");
      }
    }
    else if (verbose)
      System.out.println ("note: no filename given on commandline");

    System.out.println ("initializing Canvas ...");  // this may take a few seconds
    new SceneFrame ("VRwave", scene, true);  // shows itself

  } // main

  /**
   * command line parsing
   */

  static void parseCommandline (String[] args, Scene scene, Properties props)
  {
    CmdLineParser cmdlparser = new CmdLineParser (args, ARGOPTIONS, ARGTAGS);
    String cmderror = "VRwave. invalid command line: ";
    String cmderrmissingval = cmderror + "missing value after ";

    while (cmdlparser.more ())
    {
      int option = cmdlparser.getNext ();

      switch (option)
      {
        case ARG_HELP:
          System.out.println (USAGE);
        System.exit (0);

        case ARG_URL:
          if (cmdlparser.more ())
            baseurl_ = cmdlparser.nextArgString ();
          else
            System.out.println (cmderrmissingval + cmdlparser.currentArgString ());
        break;

        case ARG_HOME:
          if (cmdlparser.more ())
            home_ = cmdlparser.nextArgString ();
          else
            System.out.println (cmderrmissingval + cmdlparser.currentArgString ());
        break;

        case ARG_HELPURL:
          if (cmdlparser.more ())
            helpurl_ = cmdlparser.nextArgString ();
          else
            System.out.println (cmderrmissingval + cmdlparser.currentArgString ());
        break;

        case ARG_VERBOSE:
          verbose = true;
        break;

        case ARG_NOASMOOTH:
          asmooth = false;
        break;

        case ARG_NOCONVEXIFY:
          convexify = false;
        break;

        case ARG_NOICONIMAGES:
          iconimages = false;
        break;

        case ARG_LANG:
        {
          String lstr;
          if (cmdlparser.more ())
            lstr = cmdlparser.nextArgString ();
          else
          {
            System.out.println (cmderrmissingval + cmdlparser.currentArgString ());
            break;
          }
          switch (lstr.charAt (0))
          {
            case 'e':  case 'E':
              Translator.language_ = Translator.ENGLISH;
            break;
            case 'g':  case 'G':
              Translator.language_ = Translator.GERMAN;
            break;
            case 'f':  case 'F':
              Translator.language_ = Translator.FRENCH;
            break;
            case 'i':  case 'I':
              Translator.language_ = Translator.ITALIAN;
            break;
            case 's':  case 'S':
              switch (lstr.charAt (1))
              {
                case 'p':  case 'P':
                  Translator.language_ = Translator.SPANISH;
                break;
                case 't':  case 'T':
                  Translator.language_ = Translator.STYRIAN;
                break;
                default:
                  System.err.println (cmderror + "no language matching " + lstr);
              }
            break;
            default:
              System.err.println (cmderror + "no language matching " + lstr);
          }
        } // ARG_LANG
        break;

        case ARG_BACKGRD3D:
        {
          String cstr;
          if (cmdlparser.more ())
            cstr = cmdlparser.nextArgString ();
          else
          {
            System.out.println (cmderrmissingval + cmdlparser.currentArgString ());
            break;
          }

          int colval;
          // any reason for Integer.decode to be private? argh.
          // try { colval = Integer.decode (cstr).intValue (); }
          try
          {
            if (cstr.charAt (0) == '#')
            {
              colval = Integer.parseInt (cstr.substring (1), 16);
              scene.setColor (Scene.COLBACKGROUND, colval);
              break;
            }
          }
          catch (Exception e)  { }

          System.err.println (cmderror + "could not convert " + cstr + " to a color value (use #rrggbb syntax)");
        }
        break;

        case ARG_DRAWMODE:
        case ARG_INTDRAW:
        {
          String dstr;
          if (cmdlparser.more ())
            dstr = cmdlparser.nextArgString ().toLowerCase ();  // ignore case
          else
          {
            System.out.println (cmderrmissingval + cmdlparser.currentArgString ());
            break;
          }
          boolean interactive = (option == ARG_INTDRAW);

          if (dstr.indexOf ("wire") >= 0)
            scene.drawingMode (GE3D.ge3d_wireframe, interactive);
          else if (dstr.indexOf ("hidden") >= 0)
            scene.drawingMode (GE3D.ge3d_hidden_line, interactive);
          else if (dstr.indexOf ("flat") >= 0)
            scene.drawingMode (GE3D.ge3d_flat_shading, interactive);
          else if (dstr.indexOf ("smooth") >= 0)
            scene.drawingMode (GE3D.ge3d_smooth_shading, interactive);
          else if (dstr.indexOf ("textur") >= 0)
            scene.drawingMode (GE3D.ge3d_texturing, interactive);
          else if (interactive && dstr.indexOf ("same") >= 0)
            scene.drawingMode (-1, interactive);
          else
            System.err.println (cmderror + "no drawing mode matching " + dstr);

        } // drawmode, intdraw
        break;

        case ARG_CACHEPROXY:
        case ARG_FIREWALL:
        {
          boolean firewall = (option == ARG_FIREWALL);

          String hostport;
          if (cmdlparser.more ())
            hostport = cmdlparser.nextArgString ();
          else
          {
            System.out.println (cmderrmissingval + cmdlparser.currentArgString ());
            break;
          }

          int colon = hostport.indexOf (':');
          if (colon <= 0)
          {
            System.out.println (cmderror + "specify proxy/firewall as host:port\n");
            break;
          }

          String host = hostport.substring (0, colon);
          String port = hostport.substring (colon + 1);

          // the difference Java makes between caching and firewall
          // proxies should not matter in practice (differences are:
          // cache proxies will be contacted first; requests failed on
          // firewall proxis will not be retried on the original
          // address).

          if (firewall)
          {
            props.put ("firewallSet", "true");
            props.put ("firewallHost", host);
            props.put ("firewallPort", port);
          }
          else
          {
            props.put ("proxySet", "true");
            props.put ("proxyHost", host);
            props.put ("proxyPort", port);
          }
        }
        break;

        default:  // last argument
        {
          String arg = cmdlparser.currentArgString ();
          if (arg.startsWith ("-") && arg.length () > 1)
          {
            System.out.println ("warning: unknown option " + arg);
            break;
          }

          if (filename_ == null)  // first one
            filename_ = arg;
          else
            System.out.println ("waring: too many arguments. " + arg + " ignored.");
        }
      } // switch arg
    } // for each command line argument

  } // parseCommandline

} // VRwave
