/*
 * kbdbuf.h - Kernal keyboard buffer handling for VICE.
 *
 * Written by
 *  Ettore Perazzoli <ettore@comm2000.it>
 *
 * This file is part of VICE, the Versatile Commodore Emulator.
 * See README for copyright notice.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 *  02111-1307  USA.
 *
 */

#ifndef _KBDBUF_H
#define _KBDBUF_H

#include "types.h"

extern int kbd_buf_is_empty(void);
extern int kbd_buf_init(int location, int plocation, int buffer_size,
                        CLOCK mincycles);
extern void kbd_buf_shutdown(void);
extern int kbd_buf_feed(const char *s);
extern int kdb_buf_feed_string(const char *string);
extern void kbd_buf_flush(void);
extern int kbd_buf_cmdline_options_init(void);

#endif

