/*
 * Created on 08-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.util;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.TuxGuitar;

/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java - Code Style - Code Templates
 */
public class FileChooser {
    
    public static FilterFormat OPEN_FORMAT = instance().new FilterFormat(new String[] {  "*.tg;*.gp3;*.gp4;*.gp5;*.ptb" },new String[] {  "Suported Files (*.tg,*.gp3,*.gp4,*.gp5,*.ptb)"});
    
    public static FilterFormat IMPORT_MIDI_FORMAT = instance().new FilterFormat(new String[] { "*.mid" },new String[] { "Suported Files (*.mid)" });    
    
    public static FilterFormat SAVE_FORMAT = instance().new FilterFormat(new String[] { "*.gp4", "*.gp3", "*.tg" },null);
    
    public static FilterFormat EXPORT_MIDI_FORMAT = instance().new FilterFormat(new String[] { "*.mid" },null);
    
    public static FilterFormat EXPORT_PDF_FORMAT = instance().new FilterFormat(new String[] { "*.pdf" },null);
    
    public static FilterFormat EXPORT_ASCII_FORMAT = instance().new FilterFormat(new String[] { "*.tab" },null);
    
    public static FilterFormat ALL_FORMAT = instance().new FilterFormat(null,null);
	
	private static FileChooser instance;
	
    public FileChooser() {
    }    

    public static FileChooser instance() {
    	if(instance == null){
    		instance = new FileChooser();
    	}
		return instance;
	}
	
    public String open(Shell parent,FilterFormat format) {    	
        FileDialog dialog = new FileDialog(parent,SWT.OPEN);
        dialog.setFilterPath(getPath());
        dialog.setFileName(getFileName(format));
        dialog.setFilterNames(format.filterNames);        
        dialog.setFilterExtensions(format.filterExtensions);                
        return dialog.open();
    }
    
    public String save(Shell parent, FilterFormat format) {    	
        FileDialog dialog = new FileDialog(parent,SWT.SAVE);        
        dialog.setFilterPath(getPath());
        dialog.setFileName(getFileName(format));
        dialog.setFilterNames(format.filterNames);
        dialog.setFilterExtensions(format.filterExtensions);
        return dialog.open();
    }    

    private String getPath(){    	
    	return TuxGuitar.instance().getFileHistory().getFilePath();
    }
    
    private String getFileName(FilterFormat format){
    	if(format == null || format.filterExtensions == null){
    		return null;
    	}
    	String fileName = TuxGuitar.instance().getFileHistory().getFileName();    	
    	for(int i = 0; i < format.filterExtensions.length; i ++){
    		String fileExtension = fileName.substring(fileName.lastIndexOf('.')).toLowerCase();
    		int startIndex = format.filterExtensions[i].indexOf(fileExtension);
    		int endIndex = fileExtension.length() + startIndex;
    		if(startIndex > 0 && (endIndex == format.filterExtensions[i].length() || format.filterExtensions[i].charAt(endIndex) == ';')){    		
    			return fileName;
    		}
    	}    	
    	if(format.filterExtensions.length > 0 && fileName.lastIndexOf('.') > 0){    		
    		int index = fileName.lastIndexOf('.');
    		return (fileName.substring(0,fileName.lastIndexOf('.')) + format.filterExtensions[0].substring(format.filterExtensions[0].lastIndexOf('.')));    		
    	}
    	return null;
    }
    
    private class FilterFormat{
    	private String[] filterExtensions;
    	private String[] filterNames;
		
    	private FilterFormat(String[] filterExtensions, String[] filterNames) {
			this.filterExtensions = filterExtensions;
			this.filterNames = filterNames;
		}    	    	
    }
}