/*
 * Created on 02-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.items.menu;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.SystemImages;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.gui.items.MenuItems;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class PlayMenuItem implements MenuItems{
	private static final int STATUS_STOPED = 1;
	private static final int STATUS_PAUSED = 2;
	private static final int STATUS_RUNNING = 3;    	
	
    private TablatureEditor tablatureEditor;
    private Shell shell;
    private MenuItem playMenuItem;
    private Menu menu;     
    private MenuItem play;
    private MenuItem stop;
    private int status;
    
    public PlayMenuItem(Shell shell,Menu parent, int style,TablatureEditor tablatureEditor) {
        this.playMenuItem = new MenuItem(parent, style);
        this.tablatureEditor = tablatureEditor;
        this.shell = shell;
        this.menu = new Menu(shell, SWT.DROP_DOWN);
    }

    
    public void showItems(){                 				
		this.play = new MenuItem(this.menu,SWT.PUSH);
		this.play.setImage(SystemImages.TRANSPORT_ICON_PLAY_1);
		this.play.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				TuxGuitar.instance().getTransport().play(e);
			}		
		});		 
		
        this.stop = new MenuItem(this.menu, SWT.PUSH);
		this.stop.setImage(SystemImages.TRANSPORT_ICON_STOP_1);
		this.stop.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				TuxGuitar.instance().getTransport().stop(e);
			}		
		});				
        
		this.status = STATUS_STOPED;
        this.playMenuItem.setMenu(menu);             
        this.loadProperties();
    }

    public void update(){
    	int lastStatus = this.status;
    	
        if(TuxGuitar.instance().getPlayer().isRunning()){
        	this.status = STATUS_RUNNING;					
		}else if(TuxGuitar.instance().getPlayer().isPaused()){
			this.status = STATUS_PAUSED;
		}else{
			this.status = STATUS_STOPED;
        }        	
    	    	
		if(lastStatus != this.status){
			if(this.status == STATUS_RUNNING){
				this.stop.setImage(SystemImages.TRANSPORT_ICON_STOP_2);
				this.play.setImage(SystemImages.TRANSPORT_ICON_PAUSE);				
			}else if(this.status == STATUS_PAUSED){
				this.stop.setImage(SystemImages.TRANSPORT_ICON_STOP_2);
				this.play.setImage(SystemImages.TRANSPORT_ICON_PLAY_2);					
			}else if(this.status == STATUS_STOPED){
				this.stop.setImage(SystemImages.TRANSPORT_ICON_STOP_1);
				this.play.setImage(SystemImages.TRANSPORT_ICON_PLAY_1);
			}	
		}      
    }
    
    public void loadProperties(){
        this.playMenuItem.setText(TuxGuitar.getProperty("player"));  
        this.play.setText(TuxGuitar.getProperty("player.start"));
        this.stop.setText(TuxGuitar.getProperty("player.stop"));
    }         
}
