/*
 * Created on 02-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.items.menu;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.herac.tuxguitar.gui.SystemImages;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.actions.note.ChangeTiedNoteAction;
import org.herac.tuxguitar.gui.actions.note.CleanBeatAction;
import org.herac.tuxguitar.gui.actions.note.DecrementNoteSemitoneAction;
import org.herac.tuxguitar.gui.actions.note.IncrementNoteSemitoneAction;
import org.herac.tuxguitar.gui.actions.note.ShiftNoteDownAction;
import org.herac.tuxguitar.gui.actions.note.ShiftNoteUpAction;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.gui.items.MenuItems;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class NoteMenuItem implements MenuItems{
    private TablatureEditor tablatureEditor;
    private MenuItem noteMenuItem;
    private Menu menu;    
    private MenuItem tiedNote;
    private MenuItem cleanBeat;
    private MenuItem shiftUp;
    private MenuItem shiftDown;
    private MenuItem semitoneUp;
    private MenuItem semitoneDown;    
    private DurationMenuItem durationMenuItem;
    private ChordMenuItem chordMenuItem;
    private NoteEffectsMenuItem effectMenuItem;
    private DynamicMenuItem dynamicMenuItem;
    
    public NoteMenuItem(Shell shell,Menu parent, int style,TablatureEditor tablatureEditor) {
        this.noteMenuItem = new MenuItem(parent, style);
        this.tablatureEditor = tablatureEditor;
        this.menu = new Menu(shell, SWT.DROP_DOWN);
    }    
    
    public void showItems(){                       
    	//--Tied Note
        this.tiedNote = new MenuItem(this.menu, SWT.PUSH);
        this.tiedNote.setImage(SystemImages.TIED_NOTE_IMAGE);
        this.tiedNote.addSelectionListener(TuxGuitar.instance().getAction(ChangeTiedNoteAction.NAME));
    	
    	//--Tied Note
        this.cleanBeat = new MenuItem(this.menu, SWT.PUSH);
        this.cleanBeat.addSelectionListener(TuxGuitar.instance().getAction(CleanBeatAction.NAME));        
        
        //--Duration--
    	this.durationMenuItem = new DurationMenuItem(menu.getShell(),menu,SWT.CASCADE,tablatureEditor);
    	this.durationMenuItem.showItems();
    	
        //--Chord--
    	this.chordMenuItem = new ChordMenuItem(menu.getShell(),menu,SWT.CASCADE,tablatureEditor);
    	this.chordMenuItem.showItems();

        //--Effects--
    	this.effectMenuItem = new NoteEffectsMenuItem(menu.getShell(),menu,SWT.CASCADE,tablatureEditor);
    	this.effectMenuItem.showItems();    	
    	
        //--Dynamic--
    	this.dynamicMenuItem = new DynamicMenuItem(menu.getShell(),menu,SWT.CASCADE,tablatureEditor);
    	this.dynamicMenuItem.showItems();    	
    	
        //--SEPARATOR--
        new MenuItem(this.menu, SWT.SEPARATOR);
    	
    	//--Semitone Up
        this.semitoneUp = new MenuItem(this.menu, SWT.PUSH);
        this.semitoneUp.addSelectionListener(TuxGuitar.instance().getAction(IncrementNoteSemitoneAction.NAME));         
            	
    	//--Semitone Down
        this.semitoneDown = new MenuItem(this.menu, SWT.PUSH);
        this.semitoneDown.addSelectionListener(TuxGuitar.instance().getAction(DecrementNoteSemitoneAction.NAME));          

        //--SEPARATOR--
        new MenuItem(this.menu, SWT.SEPARATOR);
    	
    	//--Shift Up
        this.shiftUp = new MenuItem(this.menu, SWT.PUSH);
        this.shiftUp.addSelectionListener(TuxGuitar.instance().getAction(ShiftNoteUpAction.NAME));         
            	
    	//--Shift Down
        this.shiftDown = new MenuItem(this.menu, SWT.PUSH);
        this.shiftDown.addSelectionListener(TuxGuitar.instance().getAction(ShiftNoteDownAction.NAME));              
        
        this.noteMenuItem.setMenu(menu);        
        this.loadProperties();
    }    
    
    public void update(){
    	this.durationMenuItem.update();
    	this.chordMenuItem.update();
    	this.effectMenuItem.update();
    	this.dynamicMenuItem.update();
    }
    
    public void loadProperties(){
        this.noteMenuItem.setText(TuxGuitar.getProperty("note"));
        this.tiedNote.setText(TuxGuitar.getProperty("note.tiednote"));
        this.cleanBeat.setText(TuxGuitar.getProperty("note.clean-beat"));        
        this.semitoneUp.setText(TuxGuitar.getProperty("note.semitone-up"));
        this.semitoneDown.setText(TuxGuitar.getProperty("note.semitone-down"));                
        this.shiftUp.setText(TuxGuitar.getProperty("note.shift-up"));
        this.shiftDown.setText(TuxGuitar.getProperty("note.shift-down"));
        this.durationMenuItem.loadProperties();
        this.chordMenuItem.loadProperties();
        this.effectMenuItem.loadProperties();
        this.dynamicMenuItem.loadProperties();
    }    
}
