/*
 * Created on 18-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.items;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.gui.items.menu.CompositionMenuItem;
import org.herac.tuxguitar.gui.items.menu.EditMenuItem;
import org.herac.tuxguitar.gui.items.menu.FileMenuItem;
import org.herac.tuxguitar.gui.items.menu.HelpMenuItem;
import org.herac.tuxguitar.gui.items.menu.LayoutMenuItem;
import org.herac.tuxguitar.gui.items.menu.MarkerMenuItem;
import org.herac.tuxguitar.gui.items.menu.MeasureMenuItem;
import org.herac.tuxguitar.gui.items.menu.NoteMenuItem;
import org.herac.tuxguitar.gui.items.menu.PlayMenuItem;
import org.herac.tuxguitar.gui.items.menu.PluginMenuItem;
import org.herac.tuxguitar.gui.items.menu.SettingsMenuItem;
import org.herac.tuxguitar.gui.items.menu.TrackMenuItem;
import org.herac.tuxguitar.gui.items.tool.CompositionToolItems;
import org.herac.tuxguitar.gui.items.tool.DurationToolItems;
import org.herac.tuxguitar.gui.items.tool.DynamicToolItems;
import org.herac.tuxguitar.gui.items.tool.EditToolItems;
import org.herac.tuxguitar.gui.items.tool.FileToolItems;
import org.herac.tuxguitar.gui.items.tool.LayoutToolItems;
import org.herac.tuxguitar.gui.items.tool.MarkerToolItems;
import org.herac.tuxguitar.gui.items.tool.NoteEffectToolItems;
import org.herac.tuxguitar.gui.items.tool.NoteToolItems;
import org.herac.tuxguitar.gui.items.tool.PlayerToolItems;
import org.herac.tuxguitar.gui.items.tool.PropertiesToolItems;
import org.herac.tuxguitar.gui.items.tool.TrackToolItems;
import org.herac.tuxguitar.gui.items.tool.ViewToolItems;
import org.herac.tuxguitar.gui.items.xml.ToolBarsReader;
import org.herac.tuxguitar.gui.items.xml.ToolBarsWriter;
import org.herac.tuxguitar.gui.util.TuxGuitarFileUtils;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class ItemManager {
	private static final int HEIGHT = 32;
	
    private static ToolItems[] AVAILABLE_TOOL_BARS = new ToolItems[]{
    	new FileToolItems(),
    	new EditToolItems(),
    	new PropertiesToolItems(),
    	new TrackToolItems(),
    	new DurationToolItems(),
    	new NoteToolItems(),    
    	new CompositionToolItems(),        
    	new PlayerToolItems(),        
    	new MarkerToolItems(),        
    	new LayoutToolItems(),
    	new ViewToolItems(),
    	new NoteEffectToolItems(),
    	new DynamicToolItems()
    };
	
    private TablatureEditor tablatureEditor;    
    private Menu menu;
    private Menu popupMenu;
    private CoolBar coolBar;
    private List toolItems;
    private List menuItems;
    private List popupMenuItems;    
    private boolean layout_locked;
    
    public ItemManager(TablatureEditor tablatureEditor){
        this.tablatureEditor = tablatureEditor;        
        this.toolItems = new ArrayList();
        this.menuItems = new ArrayList();
        this.popupMenuItems = new ArrayList();
        this.layout_locked = false;
    }

    public void createItems(final Shell shell){
		this.createMenu(shell);
		this.createPopupMenu(shell);
		this.createCoolbar(shell);
    }
    
    public void createCoolbar(final Shell shell) {    	    	    	
    	this.coolBar = new CoolBar(shell,SWT.FLAT);
    	this.makeCoolItems();
    	
        FormData coolData = new FormData();
        coolData.left = new FormAttachment(0);
        coolData.right = new FormAttachment(100);
        coolData.top = new FormAttachment(0,0);        
        coolBar.setLayoutData(coolData);
        coolBar.addListener(SWT.Resize, new Listener() {
          public void handleEvent(Event event) {
        	  layoutCoolBar();
          }
        });
    }    
    
    private void clearCoolBar(){
    	if(this.coolBar != null && !this.coolBar.isDisposed()){
    		this.toolItems.clear();
    		
    		CoolItem[] items = this.coolBar.getItems();
            for(int i = 0;i < items.length; i ++){
            	items[i].dispose();
            }
    		Control[] controls = this.coolBar.getChildren();
            for(int i = 0;i < controls.length; i ++){
            	controls[i].dispose();
            }            
    	}
    }    
    
    private void layoutCoolBar(){
    	if(!this.layout_locked){
    		this.layout_locked = true;
    		
    		this.coolBar.getParent().layout();
    		this.coolBar.layout();
    		
    		this.layout_locked = false;
    	}
    }

    public void makeCoolItems(){    	
    	clearCoolBar();    	
    	List enableToolBars = getEnabledToolBars();
    	for(int i = 0; i < enableToolBars.size(); i ++){
    		String name = (String)enableToolBars.get(i);
    		for(int j = 0; j < AVAILABLE_TOOL_BARS.length; j ++){
    			if(AVAILABLE_TOOL_BARS[j].getName().trim().toLowerCase().equals(name.trim().toLowerCase())){
    				makeToolBar(AVAILABLE_TOOL_BARS[j]);
    				break;
    			}
        	}
    	}    
    	layoutCoolBar();
    }
    
    private void makeToolBar(ToolItems item){
    	ToolBar toolBar = new ToolBar(this.coolBar,SWT.FLAT | SWT.WRAP);        
    	item.showItems(toolBar);
        makeCoolItem(toolBar); 
        this.toolItems.add(item);
    }
    
    private void makeCoolItem(ToolBar toolBar){
    	CoolItem coolItem = new CoolItem(coolBar,SWT.NONE);
        coolItem.setControl(toolBar);
        Point size = toolBar.computeSize( SWT.DEFAULT,SWT.DEFAULT);        
        Point coolSize = coolItem.computeSize(size.x, HEIGHT);
	    coolItem.setMinimumSize(coolSize);
	    coolItem.setSize(coolSize);	    
    }
    
    public List getEnabledToolBars(){    	
    	return loadEnableToolBars(getAvailableToolBarNames());
    }

    public List getAvailableToolBarNames(){
    	List names = new ArrayList();    	
		for(int i = 0; i < AVAILABLE_TOOL_BARS.length; i ++){
			names.add(AVAILABLE_TOOL_BARS[i].getName());
    	}		
		return names;
    }
    
    public void createMenu(Shell shell) {
        this.menu = new Menu(shell, SWT.BAR);        
        this.menuItems.add(new FileMenuItem(shell,this.menu, SWT.CASCADE,tablatureEditor));
        this.menuItems.add(new EditMenuItem(shell,this.menu, SWT.CASCADE,tablatureEditor));
        this.menuItems.add(new LayoutMenuItem(shell,this.menu, SWT.CASCADE,tablatureEditor));
        this.menuItems.add(new CompositionMenuItem(shell,this.menu, SWT.CASCADE,tablatureEditor));
        this.menuItems.add(new TrackMenuItem(shell,this.menu, SWT.CASCADE,tablatureEditor));
        this.menuItems.add(new MeasureMenuItem(shell,this.menu, SWT.CASCADE,tablatureEditor));
        this.menuItems.add(new NoteMenuItem(shell,this.menu, SWT.CASCADE,tablatureEditor)); 
        this.menuItems.add(new MarkerMenuItem(shell,this.menu, SWT.CASCADE,tablatureEditor)); 
        this.menuItems.add(new PlayMenuItem(shell,this.menu, SWT.CASCADE,tablatureEditor));  
        this.menuItems.add(new SettingsMenuItem(shell,this.menu, SWT.CASCADE));
        this.menuItems.add(new PluginMenuItem(shell,this.menu, SWT.CASCADE)); 
        this.menuItems.add(new HelpMenuItem(shell,this.menu, SWT.CASCADE));
        this.showMenuItems(this.menuItems);
        shell.setMenuBar(this.menu);
    }    
    
    public void createPopupMenu(Shell shell) {
        this.popupMenu = new Menu(shell, SWT.POP_UP);
        this.popupMenuItems.add(new EditMenuItem(shell,this.popupMenu, SWT.CASCADE,tablatureEditor));
        this.popupMenuItems.add(new CompositionMenuItem(shell,this.popupMenu, SWT.CASCADE,tablatureEditor));
        this.popupMenuItems.add(new TrackMenuItem(shell,this.popupMenu, SWT.CASCADE,tablatureEditor));
        this.popupMenuItems.add(new MeasureMenuItem(shell,this.popupMenu, SWT.CASCADE,tablatureEditor));
        this.popupMenuItems.add(new NoteMenuItem(shell,this.popupMenu, SWT.CASCADE,tablatureEditor)); 
        this.popupMenuItems.add(new MarkerMenuItem(shell,this.popupMenu, SWT.CASCADE,tablatureEditor));
        this.popupMenuItems.add(new PlayMenuItem(shell,this.popupMenu, SWT.CASCADE,tablatureEditor)); 
        this.showMenuItems(this.popupMenuItems);
    }        
    
    private void showMenuItems(List items){
    	Iterator it = items.iterator();
    	while(it.hasNext()){
    		MenuItems item = (MenuItems)it.next();
            item.showItems();          
        }
    }
    
    public void updateItems(){
    	if(!isDisposed()){
    		updateItems(toolItems);
    		updateItems(menuItems);
    		updateItems(popupMenuItems);
    	}	
    }
    
    public void updateItems(List items){
        Iterator it = items.iterator();
        while(it.hasNext()){
            ItemBase item = (ItemBase)it.next();
            item.update();            
        }    	
    }
        
    public void loadProperties(){
    	if(!isDisposed()){
    		loadProperties(toolItems);
    		loadProperties(menuItems);
    		loadProperties(popupMenuItems);
    	}
    }

    public void loadProperties(List items){
        Iterator it = items.iterator();
        while(it.hasNext()){
            ItemBase item = (ItemBase)it.next();
            item.loadProperties();            
        }    	
    }    
    
    public CoolBar getCoolbar(){
    	return this.coolBar;
    }
    
    public Menu getPopupMenu(){
    	return this.popupMenu;
    }
        
    public List loadEnableToolBars(List availableItems) {
    	File file = new File(getCoolItemsFileName());
    	if(!file.exists()){
    		saveToolBars(availableItems);
    	}
    	return new ToolBarsReader().loadToolBars(file);
	}
    
    public void saveToolBars(List toolItems){
    	new ToolBarsWriter().saveToolBars(toolItems, getCoolItemsFileName());    	
    }    
    
    public void saveDefaultToolBars(){
    	saveToolBars(getAvailableToolBarNames());
    }
    
    private boolean isDisposed(){
    	return (this.coolBar.isDisposed() || this.menu.isDisposed() || this.popupMenu.isDisposed());
    }
    
    private String getCoolItemsFileName(){
    	return TuxGuitarFileUtils.USER_CONFIG_PREFIX + File.separator + "toolbars.xml";
    }
}

