package org.herac.tuxguitar.gui.editors.tab.edit;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.editors.tab.MeasureComponent;
import org.herac.tuxguitar.gui.editors.tab.MeasureCoords;
import org.herac.tuxguitar.gui.editors.tab.NoteCoords;
import org.herac.tuxguitar.gui.editors.tab.SongTrackCoords;
import org.herac.tuxguitar.gui.editors.tab.layout.TrackSpacing;
import org.herac.tuxguitar.gui.editors.tab.layout.ViewLayout;
import org.herac.tuxguitar.gui.undo.undoables.measure.UndoableMeasureGeneric;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.InstrumentString;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.NoteEffect;
import org.herac.tuxguitar.song.models.SongTrack;

public class MouseKit {
	private static final int FIRST_LINE_VALUES[] = new int[] {65,45,52,55};
	
	private EditorKit kit;
	private Image back = null;
	private int lastx;
	private int lasty;
	
	public MouseKit(EditorKit kit){
		this.kit = kit;
	}
	
    private ViewLayout.TrackPosition getTrackPosition(int y) {
    	TablatureEditor editor = TuxGuitar.instance().getTablatureEditor();
        return editor.getTablature().getViewLayout().getTrackPositionAt(y/*, -editor.getTablature().getVerticalBar().getSelection()*/);
    }
    
    public void tryBack(){
    	if(!kit.getTablature().isLocked()){
    		GC gc = new GC(kit.getTablature());
			if(back != null && !back.isDisposed()){
				gc.drawImage(back,lastx,lasty);					
			}
			gc.dispose();
    	}
    	if(back != null){
    		back.dispose();
    	}
    }
    
	public void mouseExit(MouseEvent e) {
		tryBack();
	}
	
	public void mouseMove(MouseEvent e) {		
		tryBack();
			  			
		SongTrackCoords track = kit.getTrackCoords(e.y);
       	if (track != null) {
       		MeasureCoords measure = kit.getMeasureCoords(track,e.x,e.y);
       		
			if(measure != null && measure.getTs() != null){				
				int minValue = track.getTrack().getString(track.getTrack().stringCount()).getValue();
				int maxValue = track.getTrack().getString(1).getValue() + 29; //Max frets = 29
				int tempValue = FIRST_LINE_VALUES[measure.getMeasure().getClef() - 1];
				int lineSpan = kit.getTablature().getViewLayout().getScoreLineSpan(); 			
				int width = 10;
				int topHeight = measure.getTs().getPosition(TrackSpacing.POSITION_SCORE_MIDDLE_LINES);
				int bottomHeight = (measure.getTs().getPosition(TrackSpacing.POSITION_TABLATURE) - measure.getTs().getPosition(TrackSpacing.POSITION_SCORE_DOWN_LINES));	
				
				int x1 = e.x - 5;
				int x2 = e.x +  5;
				//int y1 = (measure.getLastFromY() + measure.getTs().getPosition(TrackSpacing.POSITION_SCORE_MIDDLE_LINES));	
				int y1 = (measure.getPosY() + measure.getTs().getPosition(TrackSpacing.POSITION_SCORE_MIDDLE_LINES));
				int y2 = (y1 + (lineSpan * 5));				
				if(e.y < (y1 + 3) && e.y >= (y1 - topHeight)){				
					back = new Image(TuxGuitar.instance().getDisplay(),width + 1,topHeight + 1);
					GC gc = new GC(TuxGuitar.instance().getTablatureEditor().getTablature());
					gc.copyArea(back,x1, (y1 - topHeight));
					gc.setForeground(kit.getTablature().getLineColor());
					for(int y = (y1 - lineSpan); y >= (y1 - topHeight); y -= lineSpan){
						tempValue += (NoteCoords.NO_NATURAL_NOTES[(tempValue + 1) % 12])?2:1;
						tempValue += (NoteCoords.NO_NATURAL_NOTES[(tempValue + 1) % 12])?2:1;
						if(y < e.y - 5 || tempValue > maxValue){
							break;
						}
						gc.drawLine(x1, y ,x2, y );
					}			
					gc.dispose();
					
					lastx = x1;
					lasty = (y1 - topHeight);
				}else if(e.y > (y2 - 3) && e.y  < y2 + bottomHeight){
					back = new Image(TuxGuitar.instance().getDisplay(),width + 1,bottomHeight + 1);
					GC gc = new GC(TuxGuitar.instance().getTablatureEditor().getTablature());
					gc.copyArea(back,x1, y2);	
					gc.setForeground(kit.getTablature().getLineColor());
					tempValue -= 14;
					for(int y = y2; y <= (y2 + bottomHeight); y += lineSpan){
						tempValue -= (NoteCoords.NO_NATURAL_NOTES[(tempValue - 1) % 12])?2:1;
						tempValue -= (NoteCoords.NO_NATURAL_NOTES[(tempValue - 1) % 12])?2:1;
						if(y > e.y + 5 || tempValue < minValue){
							break;
						}
						gc.drawLine(x1, y ,x2, y );
					}
					gc.dispose();			
					
					lastx = x1;
					lasty = y2;					
				}				
			}						
       	}
	}
	

	public void mouseUp(MouseEvent e) {
		ViewLayout.TrackPosition pos = getTrackPosition(e.y) ;  
		
		if(pos != null){		
			SongTrackCoords track = kit.getTablature().getCaret().getSongTrackCoords();
			MeasureCoords measure = kit.getTablature().getCaret().getMeasureCoords();
			if(measure.getTs() != null){	
			int minValue = track.getTrack().getString(track.getTrack().stringCount()).getValue();
			int maxValue = track.getTrack().getString(1).getValue() + 29; //Max frets = 29
				
			int lineSpan = kit.getTablature().getViewLayout().getScoreLineSpan(); 		
			int width = 10;
				
			int topHeight = measure.getTs().getPosition(TrackSpacing.POSITION_SCORE_MIDDLE_LINES);
			int bottomHeight = (measure.getTs().getPosition(TrackSpacing.POSITION_TABLATURE) - measure.getTs().getPosition(TrackSpacing.POSITION_SCORE_DOWN_LINES));	

				
			int y1 = (pos.getPosY() + measure.getTs().getPosition(TrackSpacing.POSITION_SCORE_MIDDLE_LINES));	
			int y2 = (y1 + (lineSpan * 5));		
			
			if(e.y >= (y1 - topHeight) && e.y  < (y2 + bottomHeight)){
			
				int value = 0;
				int tempValue = FIRST_LINE_VALUES[measure.getMeasure().getClef() - 1];
				for(int i = 0;i < (topHeight / ((float)lineSpan / 2.00));i ++){
					tempValue += (NoteCoords.NO_NATURAL_NOTES[(tempValue + 1) % 12])?2:1;
				}
													
				float minorDistance = 0;
				for(float y = (y1 - topHeight); y <= (y2 + bottomHeight); y += (lineSpan / 2.00)){	                          
					if(tempValue > 0){
						float distanceY = Math.abs((float)e.y - y);
						if(value == 0 || distanceY < minorDistance){
							value = tempValue;
							minorDistance = distanceY;
						}
						tempValue -= (NoteCoords.NO_NATURAL_NOTES[(tempValue - 1) % 12])?2:1;
					}
				}			
				if(value >= minValue && value <= maxValue){
					value = getValue(value);				
					List notesAtBeat = kit.getTablature().getCaret().getMeasureCoords().getComponents(kit.getTablature().getCaret().getPosition());
					if(!removeNote(value,notesAtBeat)){
						makeNote(value,notesAtBeat);		
					}
					redrawTablature();
				}
			}
			}
		}						
	}

	private int getValue(int value){		
		int key = kit.getTablature().getCaret().getMeasureCoords().getMeasure().getKeySignature();
		if(key <= 7){
			if(NoteCoords.KEY_SIGNATURES[key][NoteCoords.SCORE_SHARP_NOTES[value % 12]] == NoteCoords.SHARP && kit.isNatural()){
				value ++;
			}
			else if(NoteCoords.KEY_SIGNATURES[key][NoteCoords.SCORE_SHARP_NOTES[value % 12]] != NoteCoords.SHARP && !kit.isNatural()){
				if(NoteCoords.NO_NATURAL_NOTES[(value + 1) % 12]){
					value ++;
				}
			}
		}else if(key > 7 ){
			if(NoteCoords.KEY_SIGNATURES[key][NoteCoords.SCORE_FLAT_NOTES[value % 12]] == NoteCoords.FLAT && kit.isNatural()){
				value --;
			}
			else if(NoteCoords.KEY_SIGNATURES[key][NoteCoords.SCORE_FLAT_NOTES[value % 12]] != NoteCoords.FLAT && !kit.isNatural()){
				if(NoteCoords.NO_NATURAL_NOTES[(value - 1) % 12]){					
					value --;
				}
			}
		}
		return value;
	}
	
	private boolean removeNote(int value,List notesAtBeat) {
		Iterator it = notesAtBeat.iterator();
		while (it.hasNext()) {
			MeasureComponent component = (MeasureComponent) it.next();
			if (component instanceof NoteCoords) {
				NoteCoords note = (NoteCoords) component;
				if (note.getRealValue() == value) {
			        //comienza el undoable
			        UndoableMeasureGeneric undoable = UndoableMeasureGeneric.startUndo();     
					
					SongManager manager = TuxGuitar.instance().getSongManager(); 
					manager.getMeasureManager().removeNote(kit.getTablature().getCaret().getMeasureCoords().getMeasure(),note.getNote());
					
			        //termia el undoable
					TuxGuitar.instance().getTablatureEditor().getUndoManager().addEdit(undoable.endUndo());   					
					
					return true;
				}
			}
		}
		return false;
	}		
	
	private void makeNote(int value,List notesAtBeat){
		SongTrack track = kit.getTablature().getCaret().getSongTrackCoords().getTrack();		
		
		long start = kit.getTablature().getCaret().getPosition();
		int string = getStringForValue(track,notesAtBeat,value);
		if(string > 0){
			int fret = (value - track.getString(string).getValue());
			int velocity = kit.getTablature().getCaret().getVelocity();
			Duration duration = (Duration)kit.getTablature().getCaret().getDuration().clone();		
			Note note = new Note(fret, start, duration, velocity, string,false,new NoteEffect());
		
			//comienza el undoable
			UndoableMeasureGeneric undoable = UndoableMeasureGeneric.startUndo();
        
			TuxGuitar.instance().getSongManager().getMeasureManager().addNote(kit.getTablature().getCaret().getMeasureCoords().getMeasure(),note);
        
			//termia el undoable
			TuxGuitar.instance().getTablatureEditor().getUndoManager().addEdit(undoable.endUndo()); 
        
			//reprodusco las notas en el pulso			
			kit.getTablature().getCaret().getMeasureCoords().playBeat(note.getStart());
			
			//asigno la cuerda seleccionada al caret
			kit.getTablature().getCaret().setStringNumber(note.getString());
		}
	}
	
	private void redrawTablature(){
		Caret caret = TuxGuitar.instance().getTablatureEditor().getTablature().getCaret();
        TuxGuitar.instance().getTablatureEditor().getTablature().getViewLayout().fireUpdate(caret.getMeasureCoords().getMeasure().getNumber(),false);
        TuxGuitar.instance().redraw();
	}
	
	private int getStringForValue(SongTrack track,List notesAtBeat,int value){
		List strings = new ArrayList();
		for(int number = 1;number <= track.stringCount();number++){
			boolean used = false;
			InstrumentString string = track.getString(number);
			Iterator it = notesAtBeat.iterator();
			while (it.hasNext()) {
				MeasureComponent component = (MeasureComponent) it.next();
				if (component instanceof NoteCoords) {
					NoteCoords note = (NoteCoords) component;
					if(note.getNote().getString() == string.getNumber()){
						used = true;
					}
				}
			}
			if(!used){
				strings.add(string);
			}
		}
		
		int minFret = -1;
		int stringForValue = 0;
		for(int i = 0;i < strings.size();i++){
			InstrumentString string = (InstrumentString)strings.get(i);						
			int fret = value - string.getValue();			
			if((fret >= 0) && (minFret < 0 || fret < minFret)){
				stringForValue = string.getNumber();
				minFret = fret;				
			}
		}						
		return stringForValue;
	}	
	
	public void mouseDoubleClick(MouseEvent e) {	
	}
	public void mouseDown(MouseEvent e) {
	}
	public void mouseEnter(MouseEvent e) {		
	}
	public void mouseHover(MouseEvent e) {		
	}
}
