/*
 * Created on 01-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.editors.tab;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.herac.tuxguitar.gui.SystemImages;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.tab.layout.TrackSpacing;
import org.herac.tuxguitar.gui.editors.tab.layout.ViewLayout;
import org.herac.tuxguitar.song.models.Component;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.Silence;
/**
 * @author julian
 * 
 * TODO To change the template for this generated type comment go to Window - Preferences - Java - Code Style - Code Templates
 */
public class SilenceCoords implements MeasureComponent {
	private static final String ALTERNATIVE_SILENCE = "S";
    /**
     * Widget de la tablatura
     */
    private Tablature tablature;
    /**
     * Coordenadas del compas
     */
    private MeasureCoords meassureCoords;
    /**
     * Silencio de Referencia
     */    
    private Silence silence;
    /**
     * Imagen del Silencio
     */
    private Image image;
    /**
     * Posicion X dentro del compas
     */
    private int posX;
    /**
     * Posicion Y dentro del compas
     */
    private int posY;    
    /**
     * Coordenadas de los dibujos de las figuras
     */
    private DurationCoords durationCoords;
    /**
     * Ancho del silencio
     */
    private int height;
    
    public SilenceCoords(Tablature tablature, MeasureCoords meassureCoords,Silence silence, int posX) {
        this.tablature = tablature;
        this.meassureCoords = meassureCoords;
        this.silence = silence;
        this.posX = posX;
    }

    public void update(ViewLayout layout) {    	
        if (getDuration() != null) {
        	this.image = SystemImages.getSilence(getDuration().getValue());        	
        	this.height = this.image.getImageData().height;        	
        }else{
        	this.height = 4;
        }
    }

    public void paint(ViewLayout layout,GC gc, int fromX, int fromY) {    	
        int x = 0;
        int y = 0;        
        int centerY = 0;        
        if(layout.isScoreEnabled()){
        	layout.setScoreNoteColor(gc);        	
        	centerY = (((layout.getScoreLineSpan() * 4) / 2) - (height / 2) - (layout.getScoreLineSpan()/2));
            x = this.posX + fromX + getSpan() - 10;
            y = fromY + centerY + meassureCoords.getTs().getPosition(TrackSpacing.POSITION_SCORE_MIDDLE_LINES);     	
        }else{
        	layout.setTabNoteColor(gc);
        	centerY =  (((this.meassureCoords.getTrackCoords().getTabHeight()) / 2) - (height / 2));     	
            x = this.posX + fromX + getSpan() - 15;
            y = fromY + centerY + meassureCoords.getTs().getPosition(TrackSpacing.POSITION_TABLATURE);   	
        }
        
        if (this.silence != null && this.image != null) {                        
            gc.drawImage(this.image, x, y);
            
            if(this.silence.getDuration().isDotted() || this.silence.getDuration().isDoubleDotted()){
                gc.drawOval(x + 23,y + 15,1,1);
                if(this.silence.getDuration().isDoubleDotted()){
                    gc.drawOval(x + 26,y + 15,1,1);
                }
            }              
            if(!this.silence.getDuration().getTupleto().isEqual(Duration.NO_TUPLETO)){
            	layout.setTupletoStyle(gc);
            	if(layout.isScoreEnabled()){
            		gc.drawString(Integer.toString(getSilence().getDuration().getTupleto().getEnters()), x + 10 ,(fromY + meassureCoords.getTs().getPosition(TrackSpacing.POSITION_TUPLETO)));
            	}else{
            		gc.drawString(Integer.toString(this.silence.getDuration().getTupleto().getEnters()),x + 14,(fromY + meassureCoords.getTs().getPosition(TrackSpacing.POSITION_TUPLETO)));
            	}
            }            
        } else {
            x = this.posX + fromX + 3 + getSpan();
            y = fromY + centerY;
            gc.drawString(ALTERNATIVE_SILENCE, x, y);
        }
        
        this.posY = y;
    }

    
    public boolean isPlaying(){
        if(meassureCoords.getTrackCoords().hasCaret()  && meassureCoords.isPlaying()){
            long playerTickPosition = TuxGuitar.instance().getPlayer().getTickPosition();
            if(playerTickPosition >= getSilence().getStart()  && playerTickPosition < getSilence().getStart() + getSilence().getDuration().getTime()){            
                return true;
            }
        }
        return false;
    }
    
    /**
     * Asigna la duracion del silencio
     */    
    public void setDuration(Duration duration){
        this.silence.setDuration(duration);
    }       
    
    public Duration getDuration() {
        return this.silence.getDuration();
    }

    /**
     * Asigna el start de el silencio
     */
    public void setStart(long start){
        this.silence.setStart(start);
    }    
    
    public long getStart() {
        return this.silence.getStart();
    }

    public Silence getSilence(){
        return this.silence;
    }
    
    public int getPosX(){
        return this.posX;
    }
    
    public int getPosY(){
        return this.posY;
    }    
    
    
    public int getSpan(){
        return meassureCoords.getSpanForComponent(this.getComponent());
    }

	public Component getComponent() {
		return getSilence();
	}
}