package org.herac.tuxguitar.gui.editors;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.editors.tab.MeasureComponent;
import org.herac.tuxguitar.gui.editors.tab.MeasureCoords;
import org.herac.tuxguitar.song.managers.SongManager;
import org.herac.tuxguitar.song.models.SongTrack;

public class EditorCache {

	private List playingComponents;
	private List caretComponents;
	private boolean playingUpdate;	
	private boolean caretUpdate;
	
	//Variables para el cache de reproduccion
	private MeasureCoords playingMeasure;
	private int lastTrack;
	private long lastTick;
	private long playBeatEnd;
	private boolean playingChanges;
	
	
	public EditorCache(){
		this.reset();
	}
		
	public void reset(){
		this.playingComponents = new ArrayList();
		this.caretComponents = new ArrayList();
		this.playingUpdate = false;
		this.caretUpdate = false;		
		
		this.playingMeasure = null;
		this.lastTrack =  0;
		this.lastTick = 0;
		this.playBeatEnd = 0;
		this.playingChanges = false;
	}
	
	public void updateCaretMode(){
		this.caretUpdate = true;	
	}

	public void updatePlayingMode(){
		this.playingUpdate = true;
		this.getPlayingComponents();
	}
	
	public List getCaretComponents() {		
		if(this.caretUpdate){
			this.caretComponents.clear();		
			Caret caret = TuxGuitar.instance().getTablatureEditor().getTablature().getCaret();
			MeasureCoords measure = caret.getMeasureCoords();
			if (measure != null) {
				this.caretComponents = measure.getComponents(caret.getPosition());
			}
			this.caretUpdate = false;
		}
		return this.caretComponents;
	}

	public List getPlayingComponents(){		
		if(this.playingUpdate){
			playingChanges = false;
			
			SongManager manager = TuxGuitar.instance().getSongManager();
			if(TuxGuitar.instance().getPlayer().isRunning()){							
				long tick = TuxGuitar.instance().getPlayer().getTickPosition();
				Caret caret = TuxGuitar.instance().getTablatureEditor().getTablature().getCaret();
				SongTrack track = caret.getSongTrackCoords().getTrack();
										
				if(playingMeasure == null || playBeatEnd == 0 || tick > playBeatEnd || tick < lastTick || track.getNumber() != lastTrack){
					this.playingComponents.clear();
					this.playBeatEnd = 0;
					this.playingChanges = true;					

					if(playingMeasure == null || !playingMeasure.hasTrack((int)track.getNumber())  || !playingMeasure.isPlaying()){
						playingMeasure = caret.getSongTrackCoords().getMeasure(manager.getTrackManager().getMeasureAt(track,tick));
					}
					if (playingMeasure != null) {					
						this.playingComponents = playingMeasure.getComponentsBetween(tick);					
						
						Iterator it = this.playingComponents.iterator();
						while(it.hasNext()){
							MeasureComponent component = (MeasureComponent)it.next();
							long componentEnd = (component.getStart() + component.getDuration().getTime());
							if(playBeatEnd == 0 || componentEnd < playBeatEnd){
								playBeatEnd = componentEnd;
							}
						}
					}					
				}
				this.lastTrack = track.getNumber();
				this.lastTick = tick;
			}
				
			this.playingUpdate = false;
		}
		
		return this.playingComponents;
	}

	public MeasureCoords getPlayingMeasure(){
		return this.playingMeasure;
	}
	
	
	public boolean shouldRedraw(){
		return this.playingChanges;
	}
}
