/*
 * Created on 17-dic-2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.herac.tuxguitar.gui.actions.effects;

import org.eclipse.swt.events.TypedEvent;
import org.herac.tuxguitar.gui.actions.Action;
import org.herac.tuxguitar.gui.editors.TablatureEditor;
import org.herac.tuxguitar.gui.editors.tab.Caret;
import org.herac.tuxguitar.gui.effects.BendEditor;
import org.herac.tuxguitar.gui.undo.undoables.measure.UndoableMeasureGeneric;
import org.herac.tuxguitar.song.models.Note;
import org.herac.tuxguitar.song.models.effects.BendEffect;

/**
 * @author julian
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class ChangeBendNoteAction extends Action{
    public static final String NAME = "action.note.effect.change-bend";

    public ChangeBendNoteAction(TablatureEditor tablatureEditor) {
        super(NAME,true,tablatureEditor);       
    }

    public boolean doAction(TypedEvent e) {
    	Note note = getEditor().getTablature().getCaret().getSelectedNote();
    	if(note != null){
    		changeBend(new BendEditor().show(getEditor().getTablature().getShell(),note));
    	}
    	return true;
    }
    
	private void changeBend(BendEffect effect){
        //comienza el undoable
    	UndoableMeasureGeneric undoable = UndoableMeasureGeneric.startUndo();    	
    	
        Caret caret = getEditor().getTablature().getCaret();
        getSongManager().getMeasureManager().changeBendNote(caret.getMeasureCoords().getMeasure(),caret.getPosition(),caret.getSelectedString().getNumber(),effect);
        updateTablature();	   
        
        //termia el undoable
        getEditor().getUndoManager().addEdit(undoable.endUndo());
	}    
	
    protected void updateTablature() {
        fireUpdate(getEditor().getTablature().getCaret().getMeasureCoords().getMeasure().getNumber());
        redraw();
    }     
    
}
