package org.herac.tuxguitar.gui;

import org.eclipse.swt.graphics.Image;
import org.herac.tuxguitar.gui.util.TuxGuitarFileUtils;
import org.herac.tuxguitar.song.models.Duration;
import org.herac.tuxguitar.song.models.MeasureHeader;

public class SystemImages {

	private static final Image[] DURATIONS = new Image[]{ 
		TuxGuitarFileUtils.loadImage("1.png"),
		TuxGuitarFileUtils.loadImage("2.png"),
		TuxGuitarFileUtils.loadImage("4.png"),
		TuxGuitarFileUtils.loadImage("8.png"),
		TuxGuitarFileUtils.loadImage("16.png"),
		TuxGuitarFileUtils.loadImage("32.png"),
		TuxGuitarFileUtils.loadImage("64.png")
	};	
	private static final Image[] SILENCES = new Image[]{ 
		TuxGuitarFileUtils.loadImage("silence1.png"),
		TuxGuitarFileUtils.loadImage("silence2.png"),
		TuxGuitarFileUtils.loadImage("silence4.png"),
		TuxGuitarFileUtils.loadImage("silence8.png"),
		TuxGuitarFileUtils.loadImage("silence16.png"),
		TuxGuitarFileUtils.loadImage("silence32.png"),
		TuxGuitarFileUtils.loadImage("silence64.png")
	};

	private static final Image[] TRIPLET_FEELS = new Image[]{ 
		TuxGuitarFileUtils.loadImage("triplet_feel_1.png"),
		TuxGuitarFileUtils.loadImage("triplet_feel_2.png"),
		TuxGuitarFileUtils.loadImage("triplet_feel_3.png")
	};	
	
	public static final Image EDIT_UNDO = TuxGuitarFileUtils.loadImage("undo.png");
	public static final Image EDIT_REDO = TuxGuitarFileUtils.loadImage("redo.png");	
	public static final Image EDIT_MODE_SELECTION = TuxGuitarFileUtils.loadImage("edit_mode_selection.png");
	public static final Image EDIT_MODE_EDITION = TuxGuitarFileUtils.loadImage("edit_mode_edition.png");
	public static final Image EDIT_MODE_EDITION_NO_NATURAL = TuxGuitarFileUtils.loadImage("edit_mode_edition_no_natural.png");
	
	public static final Image CLEF_TREBLE = TuxGuitarFileUtils.loadImage("clef_treble.png");
	public static final Image CLEF_BASS = TuxGuitarFileUtils.loadImage("clef_bass.png");
	public static final Image CLEF_TENOR = TuxGuitarFileUtils.loadImage("clef_tenor.png");
	public static final Image CLEF_ALTO = TuxGuitarFileUtils.loadImage("clef_alto.png");
	
	public static final Image KEY_NATURAL = TuxGuitarFileUtils.loadImage("natural.gif");
	public static final Image KEY_SHARP = TuxGuitarFileUtils.loadImage("sharp.gif");
	public static final Image KEY_FLAT = TuxGuitarFileUtils.loadImage("flat.gif");
	
	public static final Image LAYOUT_PAGE = TuxGuitarFileUtils.loadImage("layout_page.png");
	public static final Image LAYOUT_LINEAR = TuxGuitarFileUtils.loadImage("layout_linear.png");
	public static final Image LAYOUT_MULTITRACK = TuxGuitarFileUtils.loadImage("layout_multitrack.png");
	public static final Image LAYOUT_SCORE = TuxGuitarFileUtils.loadImage("layout_score.png");
	
	public static final Image TEMPO_IMAGE = TuxGuitarFileUtils.loadImage("tempo.png");
	
	public static final Image TRANSPORT_FIRST_1 = TuxGuitarFileUtils.loadImage("transport_first_1.png");
	public static final Image TRANSPORT_FIRST_2 = TuxGuitarFileUtils.loadImage("transport_first_2.png");
	public static final Image TRANSPORT_LAST_1 = TuxGuitarFileUtils.loadImage("transport_last_1.png");
	public static final Image TRANSPORT_LAST_2 = TuxGuitarFileUtils.loadImage("transport_last_2.png");
	public static final Image TRANSPORT_PREVIOUS_1 = TuxGuitarFileUtils.loadImage("transport_previous_1.png");
	public static final Image TRANSPORT_PREVIOUS_2 = TuxGuitarFileUtils.loadImage("transport_previous_2.png");
	public static final Image TRANSPORT_NEXT_1 = TuxGuitarFileUtils.loadImage("transport_next_1.png");
	public static final Image TRANSPORT_NEXT_2 = TuxGuitarFileUtils.loadImage("transport_next_2.png");
	public static final Image TRANSPORT_STOP_1 = TuxGuitarFileUtils.loadImage("transport_stop_1.png");
	public static final Image TRANSPORT_STOP_2 = TuxGuitarFileUtils.loadImage("transport_stop_2.png");
	public static final Image TRANSPORT_PLAY_1 = TuxGuitarFileUtils.loadImage("transport_play_1.png");
	public static final Image TRANSPORT_PLAY_2 = TuxGuitarFileUtils.loadImage("transport_play_2.png");
	public static final Image TRANSPORT_PAUSE = TuxGuitarFileUtils.loadImage("transport_pause.png");

	
	public static final Image TRANSPORT_ICON_FIRST_1 = TuxGuitarFileUtils.loadImage("transport_icon_first_1.png");
	public static final Image TRANSPORT_ICON_FIRST_2 = TuxGuitarFileUtils.loadImage("transport_icon_first_2.png");
	public static final Image TRANSPORT_ICON_LAST_1 = TuxGuitarFileUtils.loadImage("transport_icon_last_1.png");
	public static final Image TRANSPORT_ICON_LAST_2 = TuxGuitarFileUtils.loadImage("transport_icon_last_2.png");
	public static final Image TRANSPORT_ICON_PREVIOUS_1 = TuxGuitarFileUtils.loadImage("transport_icon_previous_1.png");
	public static final Image TRANSPORT_ICON_PREVIOUS_2 = TuxGuitarFileUtils.loadImage("transport_icon_previous_2.png");
	public static final Image TRANSPORT_ICON_NEXT_1 = TuxGuitarFileUtils.loadImage("transport_icon_next_1.png");
	public static final Image TRANSPORT_ICON_NEXT_2 = TuxGuitarFileUtils.loadImage("transport_icon_next_2.png");
	public static final Image TRANSPORT_ICON_STOP_1 = TuxGuitarFileUtils.loadImage("transport_icon_stop_1.png");
	public static final Image TRANSPORT_ICON_STOP_2 = TuxGuitarFileUtils.loadImage("transport_icon_stop_2.png");
	public static final Image TRANSPORT_ICON_PLAY_1 = TuxGuitarFileUtils.loadImage("transport_icon_play_1.png");
	public static final Image TRANSPORT_ICON_PLAY_2 = TuxGuitarFileUtils.loadImage("transport_icon_play_2.png");
	public static final Image TRANSPORT_ICON_PAUSE = TuxGuitarFileUtils.loadImage("transport_icon_pause.png");
	
	public static final Image MARKER_LIST = TuxGuitarFileUtils.loadImage("marker_list.png");
	public static final Image MARKER_ADD = TuxGuitarFileUtils.loadImage("marker_add.png");
	public static final Image MARKER_REMOVE = TuxGuitarFileUtils.loadImage("marker_remove.png");
	public static final Image MARKER_FIRST = TuxGuitarFileUtils.loadImage("marker_first.png");
	public static final Image MARKER_LAST = TuxGuitarFileUtils.loadImage("marker_last.png");
	public static final Image MARKER_PREVIOUS = TuxGuitarFileUtils.loadImage("marker_previous.png");
	public static final Image MARKER_NEXT = TuxGuitarFileUtils.loadImage("marker_next.png");	
	
	public static final Image ABOUT_DESCRIPTION = TuxGuitarFileUtils.loadImage("about_description.png");
	public static final Image ABOUT_LICENSE = TuxGuitarFileUtils.loadImage("about_license.png");
	public static final Image ABOUT_AUTHORS = TuxGuitarFileUtils.loadImage("about_authors.png");
	
	public static final Image TUXGUITAR_ICON = TuxGuitarFileUtils.loadImage("icon.png");
	public static final Image TUXGUITAR_SPLASH = TuxGuitarFileUtils.loadImage("splash.png");
	
	public static final Image OPTION_VIEW = TuxGuitarFileUtils.loadImage("option_view.png");
	public static final Image OPTION_STYLE = TuxGuitarFileUtils.loadImage("option_style.png");
	public static final Image OPTION_SOUND = TuxGuitarFileUtils.loadImage("option_sound.png");
	public static final Image OPTION_LANGUAGE = TuxGuitarFileUtils.loadImage("langoption.gif");
	public static final Image OPTION_TOOLBARS = TuxGuitarFileUtils.loadImage("option_toolbars.png");
	
	
	public static final Image TRACK_ADD = TuxGuitarFileUtils.loadImage("track_add.png");
	public static final Image TRACK_REMOVE = TuxGuitarFileUtils.loadImage("track_remove.png");
	
	public static final Image SONG_PROPERTIES = TuxGuitarFileUtils.loadImage("song_properties.png");
	
	public static final Image GRACE_IMAGE = TuxGuitarFileUtils.loadImage("grace.png");	
	public static final Image BEND_IMAGE = TuxGuitarFileUtils.loadImage("bend.gif");
	public static final Image TREMOLO_BAR = TuxGuitarFileUtils.loadImage("tremolo_bar.png");
	public static final Image FRETBOARD_FIRST_FRET_IMAGE = TuxGuitarFileUtils.loadImage("firstfret.png");
	public static final Image FRETBOARD_FRET_IMAGE = TuxGuitarFileUtils.loadImage("fret.png");			
	
	
	public static final Image TIME_SIGNATURE_IMAGE = TuxGuitarFileUtils.loadImage("timesignature.png");
	public static final Image TEMPO_ICON_IMAGE = TuxGuitarFileUtils.loadImage("tempoicon.png");
	public static final Image DOTTED_IMAGE = TuxGuitarFileUtils.loadImage("dotted.png");
	public static final Image DOUBLE_DOTTED_IMAGE = TuxGuitarFileUtils.loadImage("doubledotted.png");
	public static final Image TUPLETO_IMAGE = TuxGuitarFileUtils.loadImage("tupleto.png");
	public static final Image NEW_IMAGE = TuxGuitarFileUtils.loadImage("new.png");
	public static final Image OPEN_IMAGE = TuxGuitarFileUtils.loadImage("open.png");
	public static final Image SAVE_IMAGE = TuxGuitarFileUtils.loadImage("save.png");
	public static final Image SAVE_AS_IMAGE = TuxGuitarFileUtils.loadImage("save-as.png");
	public static final Image PRINT_IMAGE = TuxGuitarFileUtils.loadImage("print.png");
	public static final Image PRINT_PREVIEW_IMAGE = TuxGuitarFileUtils.loadImage("print-preview.png");
	public static final Image CHORD_IMAGE = TuxGuitarFileUtils.loadImage("chord.png");
	public static final Image TIED_NOTE_IMAGE = TuxGuitarFileUtils.loadImage("tiednote.png");
	public static final Image DEAD_NOTE_IMAGE = TuxGuitarFileUtils.loadImage("deadnote.png");
	public static final Image OPEN_REPEAT_IMAGE = TuxGuitarFileUtils.loadImage("openrepeat.png");
	public static final Image CLOSE_REPEAT_IMAGE = TuxGuitarFileUtils.loadImage("closerepeat.png");
	public static final Image FRETBOARD_IMAGE = TuxGuitarFileUtils.loadImage("fretboard.png");	
	public static final Image TRANSPORT_IMAGE = TuxGuitarFileUtils.loadImage("transport.png");
	public static final Image MIXER_IMAGE = TuxGuitarFileUtils.loadImage("mixer.png");
	
	public static final Image MIXER_METRONOME = TuxGuitarFileUtils.loadImage("mixer_metronome.png");
	
	public static final Image DYNAMIC_PIANO_PIANISSIMO = TuxGuitarFileUtils.loadImage("dynamic_ppp.png");	
	public static final Image DYNAMIC_PIANISSIMO = TuxGuitarFileUtils.loadImage("dynamic_pp.png");		
	public static final Image DYNAMIC_PIANO = TuxGuitarFileUtils.loadImage("dynamic_p.png");		
	public static final Image DYNAMIC_MEZZO_PIANO =TuxGuitarFileUtils.loadImage("dynamic_mp.png");		
	public static final Image DYNAMIC_MEZZO_FORTE = TuxGuitarFileUtils.loadImage("dynamic_mf.png");		
	public static final Image DYNAMIC_FORTE = TuxGuitarFileUtils.loadImage("dynamic_f.png");		
	public static final Image DYNAMIC_FORTISSIMO = TuxGuitarFileUtils.loadImage("dynamic_ff.png");		
	public static final Image DYNAMIC_FORTE_FORTISSIMO = TuxGuitarFileUtils.loadImage("dynamic_fff.png");	
	
	
	public static final Image EFFECT_DEAD = TuxGuitarFileUtils.loadImage("effect_dead.png");
	public static final Image EFFECT_GHOST = TuxGuitarFileUtils.loadImage("effect_ghost.png");
	public static final Image EFFECT_ACCENTUATED = TuxGuitarFileUtils.loadImage("effect_accentuated.png");
	public static final Image EFFECT_HEAVY_ACCENTUATED = TuxGuitarFileUtils.loadImage("effect_heavy_accentuated.png");
	public static final Image EFFECT_HARMONIC = TuxGuitarFileUtils.loadImage("effect_harmonic.png");
	public static final Image EFFECT_GRACE = TuxGuitarFileUtils.loadImage("effect_grace.png");
	public static final Image EFFECT_BEND = TuxGuitarFileUtils.loadImage("effect_bend.png");
	public static final Image EFFECT_TREMOLO_BAR = TuxGuitarFileUtils.loadImage("effect_tremolo_bar.png");
	public static final Image EFFECT_SLIDE = TuxGuitarFileUtils.loadImage("effect_slide.png");
	public static final Image EFFECT_HAMMER = TuxGuitarFileUtils.loadImage("effect_hammer.png");
	public static final Image EFFECT_VIBRATO = TuxGuitarFileUtils.loadImage("effect_vibrato.png");
	public static final Image EFFECT_TRILL= TuxGuitarFileUtils.loadImage("effect_trill.png");
	public static final Image EFFECT_TREMOLO_PICKING = TuxGuitarFileUtils.loadImage("effect_tremolo_picking.png");
	public static final Image EFFECT_PALM_MUTE= TuxGuitarFileUtils.loadImage("effect_palm_mute.png");	
	public static final Image EFFECT_STACCATO = TuxGuitarFileUtils.loadImage("effect_staccato.png");
	public static final Image EFFECT_TAPPING = TuxGuitarFileUtils.loadImage("effect_tapping.png");
	public static final Image EFFECT_SLAPPING = TuxGuitarFileUtils.loadImage("effect_slapping.png");
	public static final Image EFFECT_POPPING = TuxGuitarFileUtils.loadImage("effect_popping.png");
	public static final Image EFFECT_FADE_IN = TuxGuitarFileUtils.loadImage("effect_fade_in.png");
	
	public static final Image getDuration(int value){
		switch(value){
		case Duration.WHOLE:
			return DURATIONS[0];
		case Duration.HALF:
			return DURATIONS[1];			
		case Duration.QUARTER:
			return DURATIONS[2];
		case Duration.EIGHTH:
			return DURATIONS[3];
		case Duration.SIXTEENTH:
			return DURATIONS[4];
		case Duration.THIRTY_SECOND:
			return DURATIONS[5];
		case Duration.SIXTY_FOURTH:
			return DURATIONS[6];			
		}
		return null;
	}	
	
	public static final Image getSilence(int value){
		switch(value){
		case Duration.WHOLE:
			return SILENCES[0];
		case Duration.HALF:
			return SILENCES[1];			
		case Duration.QUARTER:
			return SILENCES[2];
		case Duration.EIGHTH:
			return SILENCES[3];
		case Duration.SIXTEENTH:
			return SILENCES[4];
		case Duration.THIRTY_SECOND:
			return SILENCES[5];
		case Duration.SIXTY_FOURTH:
			return SILENCES[6];			
		}
		return null;
	}
	
	public static final Image getTripletFeel(int value){
		switch(value){
		case MeasureHeader.TRIPLET_FEEL_NONE:
			return TRIPLET_FEELS[0];
		case MeasureHeader.TRIPLET_FEEL_EIGHTH:
			return TRIPLET_FEELS[1];
		case MeasureHeader.TRIPLET_FEEL_SIXTEENTH:
			return TRIPLET_FEELS[2];			
		}
		return null;
	}
	
	public static void disposeImages(){
		for(int i = 0;i < DURATIONS.length;i++){
			DURATIONS[i].dispose();
		}
		for(int i = 0;i < SILENCES.length;i++){
			SILENCES[i].dispose();
		}
		for(int i = 0;i < TRIPLET_FEELS.length;i++){
			TRIPLET_FEELS[i].dispose();
		}		
		EDIT_UNDO.dispose();
		EDIT_REDO.dispose();
		EDIT_MODE_SELECTION.dispose();
		EDIT_MODE_EDITION.dispose();		
		EDIT_MODE_EDITION_NO_NATURAL.dispose();
		
		CLEF_TREBLE.dispose();
		CLEF_BASS.dispose();
		CLEF_TENOR.dispose();
		CLEF_ALTO.dispose();
		KEY_NATURAL.dispose();
		KEY_SHARP.dispose();
		KEY_FLAT.dispose();
		LAYOUT_PAGE.dispose();
		LAYOUT_LINEAR.dispose();
		LAYOUT_MULTITRACK.dispose();
		LAYOUT_SCORE.dispose();
		
		TEMPO_IMAGE.dispose();
		TRANSPORT_FIRST_1.dispose();
		TRANSPORT_FIRST_2.dispose();
		TRANSPORT_LAST_1.dispose();
		TRANSPORT_LAST_2.dispose();
		TRANSPORT_PREVIOUS_1.dispose();
		TRANSPORT_PREVIOUS_2.dispose();
		TRANSPORT_NEXT_1.dispose();
		TRANSPORT_NEXT_2.dispose();
		TRANSPORT_STOP_1.dispose();
		TRANSPORT_STOP_2.dispose();
		TRANSPORT_PLAY_1.dispose();
		TRANSPORT_PLAY_2.dispose();
		TRANSPORT_PAUSE.dispose();
		
		TRANSPORT_ICON_FIRST_1.dispose();
		TRANSPORT_ICON_FIRST_2.dispose();
		TRANSPORT_ICON_LAST_1.dispose();
		TRANSPORT_ICON_LAST_2.dispose();
		TRANSPORT_ICON_PREVIOUS_1.dispose();
		TRANSPORT_ICON_PREVIOUS_2.dispose();
		TRANSPORT_ICON_NEXT_1.dispose();
		TRANSPORT_ICON_NEXT_2.dispose();
		TRANSPORT_ICON_STOP_1.dispose();
		TRANSPORT_ICON_STOP_2.dispose();
		TRANSPORT_ICON_PLAY_1.dispose();
		TRANSPORT_ICON_PLAY_2.dispose();
		TRANSPORT_ICON_PAUSE.dispose();		
		
		MARKER_LIST.dispose();
		MARKER_ADD.dispose();
		MARKER_REMOVE.dispose();
		MARKER_FIRST.dispose();
		MARKER_LAST.dispose();
		MARKER_PREVIOUS.dispose();
		MARKER_NEXT.dispose();		
		
		ABOUT_DESCRIPTION.dispose();
		ABOUT_AUTHORS.dispose();
		ABOUT_LICENSE.dispose();
		
		TUXGUITAR_SPLASH.dispose();
		TUXGUITAR_ICON.dispose();
		OPTION_VIEW.dispose();
		OPTION_STYLE.dispose();
		OPTION_SOUND.dispose();
		OPTION_LANGUAGE.dispose();
		OPTION_TOOLBARS.dispose();
		TRACK_ADD.dispose();
		TRACK_REMOVE.dispose();
		SONG_PROPERTIES.dispose();
		GRACE_IMAGE.dispose();
		BEND_IMAGE.dispose();
		TREMOLO_BAR.dispose();
		FRETBOARD_FIRST_FRET_IMAGE.dispose();
		FRETBOARD_FRET_IMAGE.dispose();		
		TIME_SIGNATURE_IMAGE.dispose();
		TEMPO_ICON_IMAGE.dispose();
		DOTTED_IMAGE.dispose();
		DOUBLE_DOTTED_IMAGE.dispose();
		TUPLETO_IMAGE.dispose();		
		NEW_IMAGE.dispose();
		OPEN_IMAGE.dispose();
		SAVE_IMAGE.dispose();
		SAVE_AS_IMAGE.dispose();
		PRINT_IMAGE.dispose();
		PRINT_PREVIEW_IMAGE.dispose();
		CHORD_IMAGE.dispose();
		TIED_NOTE_IMAGE.dispose();
		DEAD_NOTE_IMAGE.dispose();
		OPEN_REPEAT_IMAGE.dispose();
		CLOSE_REPEAT_IMAGE.dispose();
		FRETBOARD_IMAGE.dispose();		
		TRANSPORT_IMAGE.dispose();
		MIXER_IMAGE.dispose();
		MIXER_METRONOME.dispose();
		DYNAMIC_PIANO_PIANISSIMO.dispose();	
		DYNAMIC_PIANISSIMO.dispose();	
		DYNAMIC_PIANO.dispose();	
		DYNAMIC_MEZZO_PIANO.dispose();		
		DYNAMIC_MEZZO_FORTE.dispose();	
		DYNAMIC_FORTE.dispose();	
		DYNAMIC_FORTISSIMO .dispose();	
		DYNAMIC_FORTE_FORTISSIMO.dispose();	
				
		EFFECT_DEAD.dispose();
		EFFECT_GHOST.dispose();
		EFFECT_ACCENTUATED.dispose();
		EFFECT_HEAVY_ACCENTUATED.dispose();
		EFFECT_HARMONIC.dispose();
		EFFECT_GRACE.dispose();
		EFFECT_BEND.dispose();
		EFFECT_TREMOLO_BAR.dispose();
		EFFECT_SLIDE.dispose();
		EFFECT_HAMMER.dispose();
		EFFECT_VIBRATO.dispose();
		EFFECT_TRILL.dispose();
		EFFECT_PALM_MUTE.dispose();
		EFFECT_STACCATO.dispose();
		EFFECT_TAPPING.dispose();
		EFFECT_SLAPPING.dispose();
		EFFECT_POPPING.dispose();
		EFFECT_FADE_IN.dispose();		
	}
}
