/* Call the function version of tth, called textohtml */
/* If a second command line argument exists it is the TeX file to read
 otherwise accept interactive input. Files longer than CHARLEN are truncated.*/
#define CHARLEN 5000
# include <stdio.h>
# include <string.h>
#ifdef DMALLOC
#include <dmalloc.h>
#else
#include <malloc.h>
#endif
int main(int argc, char *argv[])
{
  extern int textohtml(char* , char* , int, char*, int);
  extern int textohtmldyn(char* , char** , char**, int);
  extern void tth_reset();
  FILE *file;
  int result,call=0;
  char tex[CHARLEN]={0};
  char *html;
  char *err;
  extern int tth_mathitalic;
  extern int tth_debug;
  tth_debug=0;
  tth_mathitalic=0; /*Turn off math italic switch*/
  if (argc>1) {
      while(argc>1){ /* Read a filename from the second argument.*/
	  if((file=fopen(argv[1],"r"))){
	      fprintf(stderr,"File translated %s\n",argv[1]);
	      while(fgets(tex,CHARLEN,file)){
		  result=textohtmldyn(tex,&html,&err,CHARLEN);
		  if (html) {
		      printf("%s",html);
		      free(html);
		  }
		  if(err) {
		      if(strlen(err))fprintf(stderr,"%s",err);
		      free(err);
		  }		  
		  if(result>1){
		    fprintf(stderr,"Error result: %d\n",result);
		    return result;}
	      }
	  }else{
	      fprintf(stderr,"Can't open file %s\n",argv[1]);
	      return 1;
	  }
	  argv++;
	  argc--;
      }
  }else{ /* Interactive line by line testing.*/
    fprintf(stdout,"Type in some TeX\n");
    while(fgets(tex,CHARLEN,stdin)){
      result=textohtmldyn(tex,&html,&err,CHARLEN);
      call++;
      printf("textohtml call number %d, result %d:\n%s\n%s",call,result,html,err);
      if(result>1){
	fprintf(stderr,"Error result: %d\n",result);
	/*return result;*/
      tth_restart();}
    };
  }
  return 0;
}

/*
Notes 14 Jun 06
One thing that is certainly wrong is that the scanner is left with the 
start stacks populated at a restart. That won't work unless it has
exited cleanly. To fix it we need to look at the code for yy_top_stack
and around there figure out a way to unpopulate the stacks something like

static void yy_clear_state()
	{
	yy_start_stack_ptr=0
	BEGIN(yy_start_stack[yy_start_stack_ptr]);
	}

}
I think this could be put into the tth_reinitialize code.

*/

