/*

`Topal': GPG/Pine integration

Copyright (C) 2001-2003  Phillip J. Brooke

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include <termios.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>

int setecho ()
{
  struct termios mode;
  struct termios new_mode;
  int fd = 0 /* stdin */;

  memset (&mode, 0, sizeof (mode));
  if (tcgetattr (fd, &mode))
    exit(1);
  mode.c_lflag = mode.c_lflag | ECHO;
  if (tcsetattr (fd, TCSADRAIN, &mode))
    exit(2);
  memset (&new_mode, 0, sizeof (new_mode));
  if (tcgetattr (fd, &new_mode))
    exit(3);
  if (memcmp (&mode, &new_mode, sizeof (mode)) != 0)
    exit(4);
  return 0;
}

int noecho ()
{
  struct termios mode;
  struct termios new_mode;
  int fd = 0; /* stdin */

  memset (&mode, 0, sizeof (mode));
  if (tcgetattr (fd, &mode))
    exit(1);
  mode.c_lflag = mode.c_lflag & ~ECHO;
  if (tcsetattr (fd, TCSADRAIN, &mode))
    exit(2);
  memset (&new_mode, 0, sizeof (new_mode));
  if (tcgetattr (fd, &new_mode))
    exit(3);
  if (memcmp (&mode, &new_mode, sizeof (mode)) != 0)
    exit(4);
  return 0;
}
