#include "rtstring.h"
#include "rtsystem.h"
#include "rtmath.h"
#include "rtmain.h"
#include "rtchar.h"

#include "rtstreams.h"
#include "rtdelphi.h"

using namespace lrt;

String str1, str2;
int iArr[10];
double dArr[10] = { Math::PI, Math::E, Math::MAX_INT, Math::MIN_INT, 0,
	22.0481, 20.1181, 23.0381, 0.815, 47.11 };

void printAll()
{
	System::println("Str1: " + str1);
	System::println("Str2: " + str2);
	System::println("ints:");
	for(int i = 0; i < 10; i++)
		System::print(String(iArr[i]) + " ");
	System::println();
	System::println("doubles:");
	for(int d = 0; d < 10; d++)
		System::print(String(dArr[d]) + " ");
	System::println();
	System::println();
}

void read()
{
	if(!File("delphi.tmp").exists()) {
		System::println("No file.");
		return;
	}
	DelphiDataInputStream* in = new DelphiDataInputStream(new FileInputStream("delphi.tmp", false));
	if(in->fail()) { System::println("Failed. "); delete in; return; }

	str1 = in->readString();
	str2 = in->readString();
	for(int i = 0; i < 10; i++)
		iArr[i] = in->readInt();
	for(int d = 0; d < 10; d++)
		dArr[d] = in->readDouble();

	if(in->fail())
		System::println("Failed while reading.");
	else
		System::println("OK.");
	delete in;
}

void write()
{
	DelphiDataOutputStream* out = new DelphiDataOutputStream(new FileOutputStream("delphi.tmp", false));
	if(out->fail()) { System::println("Failed. "); delete out; return; }

	out->writeString(str1);
	out->writeString(str2);
	out->flush();
	for(int i = 0; i < 10; i++)
	{
		out->writeInt(iArr[i]);
		out->flush();
	}
	for(int d = 0; d < 10; d++)
	{
		out->writeDouble(dArr[d]);
		out->flush();
	}

	if(out->fail())
		System::println("Failed while writing.");
	else
		System::println("OK.");
	delete out;
}

void toggleCase(String& str)
{
	for(int i = 0; i < str.length(); i++)
	{
		if(Char::isLowerCase(str[i]))
			str[i] = Char::upperCase(str[i]);
		else
			str[i] = Char::lowerCase(str[i]);
	}
}

void mutate() 
{
	toggleCase(str1);
	toggleCase(str2);
	for(int i = 0; i < 10; i++)
		iArr[i] += Math::rand(-1000, 1000);
	for(int d = 0; d < 10; d++)
		dArr[d] += (double)Math::rand(-10000, 10000) / 1000.;
}

void init()
{
	// initialize initially
	str1 = "Alles Prima? Sagt Flori und fgt noch ein paar Tests an aAbByYzZ";
	for(int s = 0; s < 10; s++)
		str2 += String(s) + ") " + str1 + "; ";
	for(int i = 0; i < 10; i++)
		iArr[i] = Math::rand(0, 1 << (i*3));
}

int rtMain(const Array<String> &args)
{
	System::println(String("sizeof(float): ") + sizeof(float));
	System::println(String("sizeof(double): ") + sizeof(double));
	System::println(String("sizeof(long double): ") + sizeof(long double));


	System::println("Initializing: *********************************");
	init();

	System::println("Reading from file: ****************************");
	read();
	printAll();

#ifdef __SYMBIAN32__
	System::read();
#endif

	System::println("Mutating: *************************************");
	mutate();
	printAll();

	System::println("Writing to file: ******************************");
	write();
/*
#ifdef __SYMBIAN32__
	lrt::Time time, ntime;
	time = lrt::Time::getCurrentTime();
	do{
		System::print("K");
		System::read();
		ntime = lrt::Time::getCurrentTime();
	}while((ntime - time).toInt() < 500);
#endif
*/
    return 0;
}

