#include "robutils.h"

#include <rtstring.h>

using namespace lrt;

namespace rt {

// statics
bool NoBreakSection::breakOccured = false;
NoBreakSection* NoBreakSection::inside = 0;

// my break handler
void NoBreakSection::breakHandler(System::BreakType type)
{
	breakOccured = true;
	System::println("\nJust a moment, please...");
}

NoBreakSection::NoBreakSection(bool ignoreBreak)
	: ignoreBreak(ignoreBreak)
{
	enter();
}

NoBreakSection::~NoBreakSection()
{
	leave();
}

void NoBreakSection::enter()
{
	// called twice?
	if(inside) {
//		System::print(String("[Don't enter ") + String((int)this, 16) + ".]");
		return;
	}
//	System::print(String("[Enter ") + String((int)this, 16) + ".]");
	// install handler
	breakOccured = false;
	System::setOnBreak(breakHandler, true);
	inside = this;
}

void NoBreakSection::leave()
{
	// called twice?
	if(inside != this) {
//		System::print(String("[Don't leave ") + String((int)this, 16) + ".]");
		return;
	}
//	System::print(String("[Leave ") + String((int)this, 16) + ".]");
	// remove handler
	System::setOnBreak(0, true);
	inside = 0;
	// handle deferred break
	if(!ignoreBreak && breakOccured)
		System::exit(255 /*, "Deferred user break."*/);
	breakOccured = false;
}


}; // namespace

