#ifndef __LRT_DEFS_H__
#define __LRT_DEFS_H__

#if defined _MSC_VER && !defined __MSVC__
#define __MSVC__
#endif

// for template specializations to T* (which are not really supported by VC++)
#ifdef __MSVC__

#define LRT_DEFINE_PTR(T) \
   template<class T> typedef T* LRT_PTR_##T;
#define LRT_PTR(T) LRT_PTR_##T
#define LRT_NPTR(T) LRT_PTR_##T

#else
#define LRT_DEFINE_PTR(T)
#define LRT_PTR(T) T*
#define LRT_NPTR(T) T

#endif // compiler

// There is no RTTI on EPOC (and it can't be enabled)
// that's a real problem, but I don't know an easy solution
#ifndef __SYMBIAN32__
#define LRT_DYNAMIC_CAST(T) dynamic_cast<T>
#else
#define LRT_DYNAMIC_CAST(T) (T)
#endif


#endif // include guard
