/*
 * Copyright (c) 2003 Red Hat, Inc. All rights reserved.
 *
 * This software may be freely redistributed under the terms of the
 * GNU General Public License.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Author: Fernando nasser
 * Created on March 18, 2003, 11:44 AM
 * Component of: Red Hat Database Control Center and Visual Explain
 */

package com.redhat.rhdb.vise;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.lang.*;

import com.redhat.rhdb.vise.resources.ActionResources;

/**
 * A panel with a pair of OK-Cancel buttons used everywhere
 *
 * @author Fernando Nasser
 * @version 0.0
 */
public class ButtonPanel extends javax.swing.JPanel
{
    /** Creates new form BeanForm */
    public ButtonPanel() {}

    /** Creates new form BeanForm */
    public ButtonPanel(ActionListener parent)
    {
	this(parent, null);
    }

    /** Creates new form BeanForm */
    public ButtonPanel(ActionListener parent, GenericAction thirdAction)
    {
	this();

        this.thirdAction = thirdAction;

	// Actions
	afactory = new ActionFactory();
	okAction     = afactory.getAction(ActionFactory.ACTION_OK);
	cancelAction = afactory.getAction(ActionFactory.ACTION_CANCEL);

	okAction.addActionListener(parent);
	cancelAction.addActionListener(parent);
	if (thirdAction != null)
	{
	    thirdAction.addActionListener(parent);
	}

	//cancelAction.setMnemonic(null);
	//okAction.setMnemonic(null);

	initComponents();

	jbCancel.getInputMap(
	    JComponent.WHEN_IN_FOCUSED_WINDOW).put(KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0),
	    cancelAction.getName()
	    );
	jbCancel.getActionMap().put(cancelAction.getName(), cancelAction);
	
	((JDialog)parent).getRootPane().setDefaultButton(jbOK);
    }

    /**
     * This method is called from within the constructor to
     * initialize the form.
     */
    private void initComponents()
    {
        jbOK = okAction.getButton();
        jbCancel = cancelAction.getButton();
	if (thirdAction != null)
	{
	    thirdButton = thirdAction.getButton();
	}

        setLayout(new javax.swing.BoxLayout(this, javax.swing.BoxLayout.X_AXIS));

        setBorder(new javax.swing.border.EmptyBorder(new java.awt.Insets(5, 0, 5, 11)));
	
        double maxHeight = Math.max(jbCancel.getPreferredSize().getHeight(), jbOK.getPreferredSize().getHeight());
        double maxWidth = Math.max(jbCancel.getPreferredSize().getWidth(), jbOK.getPreferredSize().getWidth());
	if (thirdAction != null)
	{
	    maxHeight = Math.max(maxHeight, thirdButton.getPreferredSize().getHeight());
	    maxWidth = Math.max(maxWidth, thirdButton.getPreferredSize().getWidth());
	}

        jbOK.setPreferredSize(new Dimension((int)maxWidth, (int)maxHeight));
        jbCancel.setPreferredSize(new Dimension((int)maxWidth, (int)maxHeight));
	if (thirdAction != null)
	{
            thirdButton.setPreferredSize(new Dimension((int)maxWidth, (int)maxHeight));
	}

        add(Box.createHorizontalGlue());
	if (thirdAction != null)
	{
            add(thirdButton);
            add(Box.createRigidArea(new Dimension(5, 0)));
	}
        add(jbOK);
        add(Box.createRigidArea(new Dimension(5, 0)));
        add(jbCancel);
    }

    private javax.swing.JButton jbOK;
    private javax.swing.JButton jbCancel;
    private javax.swing.JButton thirdButton;

    private ActionFactory afactory;

    private GenericAction okAction;
    private GenericAction cancelAction;
    private GenericAction thirdAction;
}
