#!/bin/bash

# First we check if we are in the qrender directory
curDir=`pwd`
curDir=`echo $curDir | sed s/qrender$//g`

if [ $# -ge 1 ]; then
  if [ "$1" == "-s" ]; then
    silenceWGet=true
  fi;
fi

if [ x"$curDir" == x"`pwd`" ];
then
  echo; echo
  echo "    Your current directory is "`pwd`
  echo "    Please execute this script in the"
  echo "    qrender sub directory of QDVDAuthor"
  echo; echo
  exit -1
fi;

# The 0.5 release from March 2009
# theLib="http://ffmpeg.mplayerhq.hu/releases/ffmpeg-0.5.tar.bz2"

# Or the latest source from svn/git
theLib="http://ffmpeg.mplayerhq.hu/releases/ffmpeg-export-snapshot.tar.bz2"
theFile=`basename $theLib`

echo
echo "This script will pull the latest ffmpeg version off of :"
echo "$theLib"

if [ x"`whoami`" == "xokan" -o x`whoami` == "xarol" ];
then
  echo avoid build local_ffmpeg at `date` > /tmp/local_ffmpeg
  qmake 
  make 
  exit
fi;

# Check if the file exists ...
if [ -e $theFile ];
then
  rm $theFile
fi;
if [ -e `basename $theFile .bz2` ];
then
  rm `basename $theFile .bz2`
fi;

# One little hack to avoid breaking this build if ffmpeg changes 
whichLib=`wget --spider http://qdvdauthor.sf.net/ffmpeg_location.txt 2>&1 | grep "200 OK"`
if [ "x$whichLib" != "x" ]; 
then
  # Found a workaround library. Now lets get the location and run with it.
  wget http://qdvdauthor.sf.net/ffmpeg_location.txt
  if [ -f ffmpeg_location.txt ];
  then
    theLib=`cat ffmpeg_location.txt`
  fi;
fi;

res=`wget --spider $theLib 2>&1 | grep "200 OK"`

if [ "x$res" == "x" ];
then
  # Not found, lets try to use svn to DL the source
  svn checkout svn://svn.mplayerhq.hu/ffmpeg/trunk ffmpeg
  if [ ! -d ffmpeg ];
  then
    echo "Could not download ffmpeg. Please try to manually install it"
    echo "on your system and if needed set the FFMPEG environment"
    echo "variable before compiling qrender"
    exit -1
  else
    mv ffmpeg ffmpeg-snapshot
    ln -s ffmpeg-snapshot ffmpeg
  fi;
else
  # The tar file exists ...
  theFile=`basename $theLib`
  if [ "x$silenceWGet" != "x" ]; then
    wget $theLib >/dev/null 2>&1
  else
    wget $theLib
  fi;
  bzip2 -d $theFile
  theFile=`basename $theFile .bz2`
  extractDir=`tar --list -f $theFile | grep INSTALL | sed "s/\\/INSTALL$//"`
  tar -xf $theFile
  if [ -e ffmpeg ]; then
    rm ffmpeg
  fi;
  ln -s "$extractDir" ffmpeg
fi;

cd ffmpeg
#./configure --prefix=/home/varol/utils/ffmpeg --enable-gpl --enable-nonfree --enable-shared --enable-static
#./configure --prefix="`pwd`" --enable-gpl --enable-swscale --enable-static --enable-shared
./configure --prefix="`pwd`" --enable-gpl --enable-static --enable-shared

make && make install

# At this point the static libraries should have been built

# one last thing to do is to copy the header files to the include/ffmpeg directory
cd include
mkdir ffmpeg
cp `find . -name "*.h"` ffmpeg/

# and lastly we should clean qrender and re-build it
cd ../..
make clean 

qmake

make 

