// File:	TFunction_DriverTable.cxx
// Created:	Fri Jun 11 17:58:49 1999
// Author:	Vladislav ROMASHKO
//		<vro@flox.nnov.matra-dtv.fr>


#include <TFunction_DriverTable.ixx>

#include <TFunction_DataMapOfGUIDDriver.hxx>
#include <TFunction_DataMapIteratorOfDataMapOfGUIDDriver.hxx>
#include <TFunction_Driver.hxx>
#include <TCollection_ExtendedString.hxx>
#include <TDF.hxx>


static Handle(TFunction_DriverTable) DT;

//=======================================================================
//function : Get
//purpose  : 
//=======================================================================

Handle(TFunction_DriverTable) TFunction_DriverTable::Get()
{
  if (DT.IsNull()) DT = new TFunction_DriverTable;
  return DT;
}

//=======================================================================
//function : TFunction_DriverTable
//purpose  : Constructor
//=======================================================================

TFunction_DriverTable::TFunction_DriverTable()
{}

//=======================================================================
//function : AddDriver
//purpose  : Adds a driver to the DriverTable
//=======================================================================

Standard_Boolean TFunction_DriverTable::AddDriver(const Standard_GUID&            guid,
						  const Handle(TFunction_Driver)& driver)
{
  return myDrivers.Bind(guid,driver);
}

//=======================================================================
//function : HasDriver
//purpose  : 
//=======================================================================

Standard_Boolean TFunction_DriverTable::HasDriver(const Standard_GUID& guid) const
{
  return myDrivers.IsBound(guid);
}

//=======================================================================
//function : FindDriver
//purpose  : Returns the driver if find
//=======================================================================

Standard_Boolean TFunction_DriverTable::FindDriver(const Standard_GUID& guid,
						   Handle(TFunction_Driver)& driver) const
{
  if (myDrivers.IsBound(guid))
  {
    driver = myDrivers.Find(guid);
    return Standard_True;
  }
  return Standard_False;
}

//=======================================================================
//function : Dump
//purpose  : 
//=======================================================================

Standard_OStream& TFunction_DriverTable::Dump(Standard_OStream& anOS) const
{
  TFunction_DataMapIteratorOfDataMapOfGUIDDriver itr(myDrivers);
  for (; itr.More(); itr.Next())
  {
    itr.Key().ShallowDump(anOS); 
    anOS<<"\t";
    TCollection_ExtendedString es;
    TDF::ProgIDFromGUID(itr.Key(), es);
    anOS<<es<<"\n";
  }
  return anOS;
}

//=======================================================================
//function : RemoveDriver
//purpose  : Removes a driver from the DriverTable
//=======================================================================

Standard_Boolean TFunction_DriverTable::RemoveDriver(const Standard_GUID& guid)
{
  return myDrivers.UnBind(guid);
}

//=======================================================================
//function : Clear
//purpose  : Removes all drivers
//=======================================================================

void TFunction_DriverTable::Clear()
{
  myDrivers.Clear();
}
