
#define NOVIRTUAL

// File		OpenGl_GraphicDriver_7.cxx
// Created	Mardi 28 janvier 1997
// Author	CAL
// Modified     GG 10/11/99 PRO19603 Change the Redraw method (add redraw area capabillity)
//              EUG 07/10/99 G003 Add DegenerateStructure() and
//                                    SetBackFacingModel() methods.

//-Copyright	MatraDatavision 1997

//-Version	

//-Design	Declaration des variables specifiques aux Drivers

//-Warning	Un driver encapsule les Pex et OpenGl drivers

//-References	

//-Language	C++ 2.0

//-Declarations

// for the class
#include <OpenGl_GraphicDriver.jxx>

#include <Aspect_DriverDefinitionError.hxx>

extern "C" {
#include <InterfaceGraphic_Cextern.hxx>
}

//-Aliases

//-Global data definitions

//-Methods, in order

void OpenGl_GraphicDriver::ActivateView (const Graphic3d_CView& ACView) {
#ifndef VIRTUAL

Graphic3d_CView MyCView = ACView;

	if (MyTraceLevel) {
		PrintFunction ("call_togl_activateview");
		PrintCView (MyCView, 1);
	}
	call_togl_activateview (&MyCView);

#endif
}

void OpenGl_GraphicDriver::AntiAliasing (const Graphic3d_CView& ACView, const Standard_Boolean AFlag) {
#ifndef VIRTUAL

Graphic3d_CView MyCView = ACView;

	if (MyTraceLevel) {
		PrintFunction ("call_togl_antialiasing");
		PrintCView (MyCView, 1);
		PrintBoolean ("AFlag", AFlag);
	}
	call_togl_antialiasing (&MyCView, (AFlag ? 1 : 0));

#endif
}

void OpenGl_GraphicDriver::Background (const Graphic3d_CView& ACView) {
#ifndef VIRTUAL

Graphic3d_CView MyCView = ACView;

	if (MyTraceLevel) {
		PrintFunction ("call_togl_background");
		PrintCView (MyCView, 1);
	}
	call_togl_background (&MyCView);

#endif
}

void OpenGl_GraphicDriver::Blink (const Graphic3d_CStructure& ACStructure, const Standard_Boolean Create) {
#ifndef VIRTUAL

Graphic3d_CStructure MyCStructure = ACStructure;

	if (MyTraceLevel) {
		PrintFunction ("call_togl_blink");
		PrintCStructure (MyCStructure, 1);
		PrintBoolean ("Create", Create);
	}
	call_togl_blink (&MyCStructure, (Create ? 1 : 0));

#endif
}

void OpenGl_GraphicDriver::BoundaryBox (const Graphic3d_CStructure& ACStructure, const Standard_Boolean Create) {
#ifndef VIRTUAL

Graphic3d_CStructure MyCStructure = ACStructure;

	if (MyTraceLevel) {
		PrintFunction ("call_togl_boundarybox");
		PrintCStructure (MyCStructure, 1);
		PrintBoolean ("Create", Create);
	}
	call_togl_boundarybox (&MyCStructure, (Create ? 1 : 0));

#endif
}

void OpenGl_GraphicDriver::HighlightColor (const Graphic3d_CStructure& ACStructure, const Standard_ShortReal R, const Standard_ShortReal G, const Standard_ShortReal B, const Standard_Boolean Create) {
#ifndef VIRTUAL

Graphic3d_CStructure MyCStructure = ACStructure;

	if (MyTraceLevel) {
		PrintFunction ("call_togl_highlightcolor");
		PrintCStructure (MyCStructure, 1);
		PrintShortReal ("R", R);
		PrintShortReal ("G", G);
		PrintShortReal ("B", B);
	}
CALL_DEF_COLOR acolor;
	acolor.r	= R;
	acolor.g	= G;
	acolor.b	= B;
	call_togl_highlightcolor (&MyCStructure, &acolor, (Create ? 1 : 0));

#endif
}

void OpenGl_GraphicDriver::NameSetStructure (const Graphic3d_CStructure& ACStructure) {
#ifndef VIRTUAL

Graphic3d_CStructure MyCStructure = ACStructure;

	if (MyTraceLevel) {
		PrintFunction ("call_togl_namesetstructure");
		PrintCStructure (MyCStructure, 1);
	}
	call_togl_namesetstructure (&MyCStructure);

#endif
}

void OpenGl_GraphicDriver::ClipLimit (const Graphic3d_CView& ACView, const Standard_Boolean AWait) {
#ifndef VIRTUAL

Graphic3d_CView MyCView = ACView;

	if (MyTraceLevel) {
		PrintFunction ("call_togl_cliplimit");
		PrintCView (MyCView, 1);
		PrintBoolean ("AWait", AWait);
	}
	call_togl_cliplimit (&MyCView, (AWait ? 1 : 0));

#endif
}

void OpenGl_GraphicDriver::DeactivateView (const Graphic3d_CView& ACView) {
#ifndef VIRTUAL

Graphic3d_CView MyCView = ACView;

	if (MyTraceLevel) {
		PrintFunction ("call_togl_deactivateview");
		PrintCView (MyCView, 1);
	}
	call_togl_deactivateview (&MyCView);

#endif
}

void OpenGl_GraphicDriver::DepthCueing (const Graphic3d_CView& ACView, const Standard_Boolean AFlag) {
#ifndef VIRTUAL

Graphic3d_CView MyCView = ACView;

	if (MyTraceLevel) {
		PrintFunction ("call_togl_depthcueing");
		PrintCView (MyCView, 1);
		PrintBoolean ("AFlag", AFlag);
	}
	call_togl_depthcueing (&MyCView, (AFlag ? 1 : 0));

#endif
}

Standard_Boolean OpenGl_GraphicDriver::ProjectRaster (const Graphic3d_CView& ACView, const Standard_ShortReal AX, const Standard_ShortReal AY, const Standard_ShortReal AZ, Standard_Integer& AU, Standard_Integer& AV) {
#ifndef VIRTUAL

Graphic3d_CView MyCView = ACView;

Standard_Integer Result;

	if (MyTraceLevel) {
		PrintFunction ("call_togl_project_raster");
		PrintCView (MyCView, 1);
	}
	Result = call_togl_project_raster (ACView.ViewId, AX, AY, AZ, &AU, &AV);
	if (MyTraceLevel) {
		PrintIResult ("call_togl_project_raster", Result);
	}
	return (Result == 0 ? Standard_True : Standard_False);

#else
	return Standard_False;
#endif
}

Standard_Boolean OpenGl_GraphicDriver::UnProjectRaster (const Graphic3d_CView& ACView, const Standard_Integer Axm, const Standard_Integer Aym, const Standard_Integer AXM, const Standard_Integer AYM, const Standard_Integer AU, const Standard_Integer AV, Standard_ShortReal& Ax, Standard_ShortReal& Ay, Standard_ShortReal& Az) {
#ifndef VIRTUAL

Graphic3d_CView MyCView = ACView;

Standard_Integer Result;

	if (MyTraceLevel) {
		PrintFunction ("call_togl_unproject_raster");
		PrintCView (MyCView, 1);
	}
	Result = call_togl_unproject_raster
		(ACView.ViewId, Axm, Aym, AXM, AYM, AU, AV, &Ax, &Ay, &Az);
	if (MyTraceLevel) {
		PrintIResult ("call_togl_unproject_raster", Result);
	}
	return (Result == 0 ? Standard_True : Standard_False);

#else
	return Standard_False;
#endif
}

void OpenGl_GraphicDriver::RatioWindow (const Graphic3d_CView& ACView) {
#ifndef VIRTUAL

Graphic3d_CView MyCView = ACView;

	if (MyTraceLevel) {
		PrintFunction ("call_togl_ratio_window");
		PrintCView (MyCView, 1);
	}
	call_togl_ratio_window (&MyCView);

#endif
}

void OpenGl_GraphicDriver::Redraw (const Graphic3d_CView& ACView, const Aspect_CLayer2d& ACUnderLayer, const Aspect_CLayer2d& ACOverLayer, const Standard_Integer x, const Standard_Integer y, const Standard_Integer width, const Standard_Integer height) {
#ifndef VIRTUAL

Graphic3d_CView MyCView = ACView;
Aspect_CLayer2d MyCUnderLayer = ACUnderLayer;
Aspect_CLayer2d MyCOverLayer = ACOverLayer;

	if (MyTraceLevel) {
		PrintFunction ("call_togl_redraw");
		PrintCView (MyCView, 1);
	}
//PRO19603
        if( width <= 0 || height <= 0  )
          call_togl_redraw (&MyCView, &MyCUnderLayer, &MyCOverLayer);
        else {
          call_togl_redraw_area (&MyCView, &MyCUnderLayer, &MyCOverLayer,
                                 x, y, width, height);
        }
//PRO19603
#endif
}

void OpenGl_GraphicDriver::RemoveView (const Graphic3d_CView& ACView) {
#ifndef VIRTUAL

Graphic3d_CView MyCView = ACView;

	if (MyTraceLevel) {
		PrintFunction ("call_togl_removeview");
		PrintCView (MyCView, 1);
	}
	call_togl_removeview (&MyCView);

#endif
}

void OpenGl_GraphicDriver::SetLight (const Graphic3d_CView& ACView) {
#ifndef VIRTUAL

Graphic3d_CView MyCView = ACView;

	if (MyTraceLevel) {
		PrintFunction ("call_togl_setlight");
		PrintCView (MyCView, 1);
	}
	call_togl_setlight (&MyCView);

#endif
}

void OpenGl_GraphicDriver::SetPlane (const Graphic3d_CView& ACView) {
#ifndef VIRTUAL

Graphic3d_CView MyCView = ACView;

	if (MyTraceLevel) {
		PrintFunction ("call_togl_setplane");
		PrintCView (MyCView, 1);
	}
	call_togl_setplane (&MyCView);

#endif
}

void OpenGl_GraphicDriver::SetVisualisation (const Graphic3d_CView& ACView) {
#ifndef VIRTUAL

Graphic3d_CView MyCView = ACView;

	if (MyTraceLevel) {
		PrintFunction ("call_togl_setvisualisation");
		PrintCView (MyCView, 1);
	}
	call_togl_setvisualisation (&MyCView);

#endif
}

void OpenGl_GraphicDriver::TransformStructure (const Graphic3d_CStructure& ACStructure) {
#ifndef VIRTUAL

Graphic3d_CStructure MyCStructure = ACStructure;

	if (MyTraceLevel) {
		PrintFunction ("call_togl_transformstructure");
		PrintCStructure (MyCStructure, 1);
	}
	call_togl_transformstructure (&MyCStructure);

#endif
}

void OpenGl_GraphicDriver :: DegenerateStructure (
                              const Graphic3d_CStructure& ACStructure
                             ) {
#ifndef VIRTUAL
 Graphic3d_CStructure MyCStructure = ACStructure;

 if ( MyTraceLevel ) {

  PrintFunction ( "call_togl_degeneratestructure" );
  PrintCStructure ( MyCStructure, 1 );

 }  // end if

 call_togl_degeneratestructure ( &MyCStructure );
#endif
}  // end OpenGl_GraphicDriver :: DegenerateStructure

void OpenGl_GraphicDriver::Transparency (const Graphic3d_CView& ACView, const Standard_Boolean AFlag) {
#ifndef VIRTUAL

Graphic3d_CView MyCView = ACView;

	if (MyTraceLevel) {
		PrintFunction ("call_togl_transparency");
		PrintCView (MyCView, 1);
		PrintBoolean ("AFlag", AFlag);
	}
	call_togl_transparency (MyCView.WsId, MyCView.ViewId, (AFlag ? 1 : 0));

#endif
}

void OpenGl_GraphicDriver::Update (const Graphic3d_CView& ACView, const Aspect_CLayer2d& ACUnderLayer, const Aspect_CLayer2d& ACOverLayer) {
#ifndef VIRTUAL

Graphic3d_CView MyCView = ACView;
Aspect_CLayer2d MyCUnderLayer = ACUnderLayer;
Aspect_CLayer2d MyCOverLayer = ACOverLayer;

	if (MyTraceLevel) {
		PrintFunction ("call_togl_update");
		PrintCView (MyCView, 1);
	}
	call_togl_update (&MyCView, &MyCUnderLayer, &MyCOverLayer);

#endif
}

Standard_Boolean OpenGl_GraphicDriver::View (Graphic3d_CView& ACView) {
#ifndef VIRTUAL

Graphic3d_CView MyCView = ACView;
Standard_Integer Result;

	if (MyTraceLevel) {
		PrintFunction ("call_togl_view");
		PrintCView (MyCView, 1);
	}
	Result = call_togl_view (&MyCView);
	if (MyTraceLevel) {
		PrintIResult ("call_togl_view", Result);
	}
	return (Result == 1 ? Standard_True : Standard_False);

#else
	return Standard_False;
#endif
}

void OpenGl_GraphicDriver::ViewMapping (const Graphic3d_CView& ACView, const Standard_Boolean AWait) {
#ifndef VIRTUAL

Graphic3d_CView MyCView = ACView;
Standard_Integer Result;

	if (MyTraceLevel) {
		PrintFunction ("call_togl_viewmapping");
		PrintCView (MyCView, 1);
		PrintBoolean ("AWait", AWait);
	}
	Result = call_togl_viewmapping (&MyCView, (AWait ? 1 : 0));
	if (MyTraceLevel) {
		PrintIResult ("call_togl_viewmapping", Result);
	}

#endif
}

void OpenGl_GraphicDriver::ViewOrientation (const Graphic3d_CView& ACView, const Standard_Boolean AWait) {
#ifndef VIRTUAL

Graphic3d_CView MyCView = ACView;
Standard_Integer Result;

	if (MyTraceLevel) {
		PrintFunction ("call_togl_vieworientation");
		PrintCView (MyCView, 1);
		PrintBoolean ("AWait", AWait);
	}
	Result = call_togl_vieworientation (&MyCView, (AWait ? 1 : 0));
	if (MyTraceLevel) {
		PrintIResult ("call_togl_viewmapping", Result);
	}

#endif
}

void OpenGl_GraphicDriver :: SetBackFacingModel ( const Graphic3d_CView& aView )
 {
#ifndef VIRTUAL
 Graphic3d_CView myView = aView;

 if ( MyTraceLevel ) {

  PrintFunction ( "call_togl_backfacing" );
  PrintCView ( myView, 1 );

 }  // end if

 call_togl_backfacing ( &myView );
#endif  // VIRTUAL
}  // end Graphic3d_GraphicDriver :: SetBackFacingModel
