/* ZSNORM.f -- translated by f2c (version 19960827).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "Data_f2c.h"
#ifdef WNT
#include <MathBase.h>
#else 
#define  __MathBase_API
#endif
__MathBase_API doublereal mzsnorm_(ndimen, vecteu)
integer *ndimen;
doublereal *vecteu;
{
    /* System generated locals */
    integer i__1;
    doublereal ret_val, d__1, d__2;

    /* Builtin functions */
    double sqrt();

    /* Local variables */
    static doublereal xsom;
    static integer i__, irmax;


/*      IMPLICIT INTEGER (I-N),DOUBLE PRECISION (A-H,O-Z) */

/* < */
/* **NOTICE */
/*  THIS SOFTWARE IS THE PROPERTY OF CISIGRAPH. */
/*  THIS CODE MUST NOT BE DISTRIBUTED OR COPIED WITHOUT THE PRIOR */
/*  WRITTEN PERMISSION OF CISIGRAPH AND IS ONLY TO BE USED ON THE */
/*  SITE WHERE IT IS INSTALLED BY CISIGRAPH */
/* **NOTICE */

/* ***********************************************************************
 */

/*     FONCTION : */
/*     ---------- */
/*        Sert a calculer la norme euclidienne d'un vecteur : */
/*                       ____________________________ */
/*                  Z = V  V(1)**2 + V(2)**2 + ... */

/*     MOTS CLES : */
/*     ----------- */
/*        SURMFACIQUE, */

/*     ARGUMENTS D'ENTREE : */
/*     ------------------ */
/*        NDIMEN : Dimension du vecteur */
/*        VECTEU : vecteur de dimension NDIMEN */

/*     ARGUMENTS DE SORTIE : */
/*     ------------------- */
/*        MZSNORM : Valeur de la norme euclidienne du vecteur VECTEU */

/*     COMMONS UTILISES   : */
/*     ---------------- */

/*      .Neant. */

/*     REFERENCES APPELEES   : */
/*     ---------------------- */
/*     Type  Name */
/*      R*8  ABS            R*8  SQRT */

/*     DESCRIPTION/REMARQUES/LIMITATIONS : */
/*     ----------------------------------- */
/*        Pour limiter les risques d'overflow, on met en facteur */
/*     le terme de plus forte valeur absolue : */
/*                                _______________________ */
/*                  Z = !V(1)! * V  1 + (V(2)/V(1))**2 + ... */

/* $    HISTORIQUE DES MODIFICATIONS   : */
/*     -------------------------------- */
/*     11-09-1995 : JMF ; implicit none */
/*     20-03-89 : DH ; Creation version originale */
/* > */
/* ***********************************************************************
 */
/*                      DECLARATIONS */
/* ***********************************************************************
 */


/* ***********************************************************************
 */
/*                     TRAITEMENT */
/* ***********************************************************************
 */

/* ___ Recherche du terme de plus forte valeur absolue */

    /* Parameter adjustments */
    --vecteu;

    /* Function Body */
    irmax = 1;
    i__1 = *ndimen;
    for (i__ = 2; i__ <= i__1; ++i__) {
	if ((d__1 = vecteu[irmax], abs(d__1)) < (d__2 = vecteu[i__], abs(d__2)
		)) {
	    irmax = i__;
	}
/* L100: */
    }

/* ___ Calcul de la norme */

    if ((d__1 = vecteu[irmax], abs(d__1)) < 1.) {
	xsom = 0.;
	i__1 = *ndimen;
	for (i__ = 1; i__ <= i__1; ++i__) {
/* Computing 2nd power */
	    d__1 = vecteu[i__];
	    xsom += d__1 * d__1;
/* L200: */
	}
	ret_val = sqrt(xsom);
    } else {
	xsom = 0.;
	i__1 = *ndimen;
	for (i__ = 1; i__ <= i__1; ++i__) {
	    if (i__ == irmax) {
		xsom += 1.;
	    } else {
/* Computing 2nd power */
		d__1 = vecteu[i__] / vecteu[irmax];
		xsom += d__1 * d__1;
	    }
/* L300: */
	}
	ret_val = (d__1 = vecteu[irmax], abs(d__1)) * sqrt(xsom);
    }

/* ***********************************************************************
 */
/*                   RETOUR PROGRAMME APPELANT */
/* ***********************************************************************
 */

    return ret_val;
} /* mzsnorm_ */

