// File:	MDataStd_1.cxx
// Created:	Tue Aug 12 11:40:09 1997
// Author:	VAUTHIER Jean-Claude


#include <MDataStd.ixx>
#include <MgtGeom.hxx>
#include <Geom_Curve.hxx>
#include <Geom_Surface.hxx>
#include <Geom_Point.hxx>
#include <Geom_Axis1Placement.hxx>
#include <Geom_Axis2Placement.hxx>
#include <Geom_Direction.hxx>
#include <Geom_VectorWithMagnitude.hxx>
#include <PGeom_Curve.hxx>
#include <PGeom_Surface.hxx>
#include <PGeom_Point.hxx>
#include <PGeom_Axis1Placement.hxx>
#include <PGeom_Axis2Placement.hxx>
#include <PGeom_Direction.hxx>
#include <PGeom_VectorWithMagnitude.hxx>
#include <Standard_NullObject.hxx>



Handle(Geom_Geometry) MDataStd::Translate (const Handle(PGeom_Geometry)& Geometry) {
  Handle(Standard_Type) GeometryType = Geometry->DynamicType ();

  if (GeometryType == STANDARD_TYPE(PGeom_Surface)) {
    Handle(PGeom_Surface)& Surface = (Handle(PGeom_Surface)&) Geometry;
    return MgtGeom::Translate (Surface);
  }
  else if (GeometryType == STANDARD_TYPE(PGeom_Curve)) {
    Handle(PGeom_Curve)& Curve = (Handle(PGeom_Curve)&) Geometry;
    return MgtGeom::Translate (Curve);
  }
  else if (GeometryType == STANDARD_TYPE(PGeom_Point)) {
    Handle(PGeom_Point)& Point = (Handle(PGeom_Point)&) Geometry;
    return MgtGeom::Translate (Point);
  }
  else if (GeometryType == STANDARD_TYPE(PGeom_Axis1Placement)) {
    Handle(PGeom_Axis1Placement)& Axis1 = (Handle(PGeom_Axis1Placement)&) Geometry;
    return MgtGeom::Translate (Axis1);
  }
  else if (GeometryType == STANDARD_TYPE(Geom_Axis2Placement)) {
    Handle(PGeom_Axis2Placement)& Axis2 = (Handle(PGeom_Axis2Placement)&) Geometry;
    return MgtGeom::Translate (Axis2);
  }
  else if (GeometryType == STANDARD_TYPE(PGeom_Direction)) {
    Handle(PGeom_Direction)& Dir = (Handle(PGeom_Direction)&) Geometry;
    return MgtGeom::Translate (Dir);
  }
  else if (GeometryType == STANDARD_TYPE(PGeom_VectorWithMagnitude)) {
    Handle(PGeom_VectorWithMagnitude)& Vec = (Handle(PGeom_VectorWithMagnitude)&) Geometry;
    return MgtGeom::Translate (Vec);
  }
  else {
    Standard_NullObject::Raise("No mapping for the current Persistent Geometry");
  }

  Handle(Geom_Surface) dummy;
  return dummy;
}


Handle(PGeom_Geometry) MDataStd::Translate (const Handle(Geom_Geometry)& Geometry) {

  Handle(Standard_Type) GeometryType = Geometry->DynamicType ();

  if (GeometryType == STANDARD_TYPE(Geom_Surface)) {
    Handle(Geom_Surface)& Surface = (Handle(Geom_Surface)&) Geometry;
    return MgtGeom::Translate (Surface);
  }
  else if (GeometryType == STANDARD_TYPE(Geom_Curve)) {
    Handle(Geom_Curve)& Curve = (Handle(Geom_Curve)&) Geometry;
    return MgtGeom::Translate (Curve);
  }
  else if (GeometryType == STANDARD_TYPE(Geom_Point)) {
    Handle(Geom_Point)& Point = (Handle(Geom_Point)&) Geometry;
    return MgtGeom::Translate (Point);
  }
  else if (GeometryType == STANDARD_TYPE(Geom_Axis1Placement)) {
    Handle(Geom_Axis1Placement)& Axis1 = (Handle(Geom_Axis1Placement)&) Geometry;
    return MgtGeom::Translate (Axis1);
  }
  else if (GeometryType == STANDARD_TYPE(Geom_Axis2Placement)) {
    Handle(Geom_Axis2Placement)& Axis2 = (Handle(Geom_Axis2Placement)&) Geometry;
    return MgtGeom::Translate (Axis2);
  }
  else if (GeometryType == STANDARD_TYPE(Geom_Direction)) {
    Handle(Geom_Direction)& Dir = (Handle(Geom_Direction)&) Geometry;
    return MgtGeom::Translate (Dir);
  }
  else if (GeometryType == STANDARD_TYPE(Geom_VectorWithMagnitude)) {
    Handle(Geom_VectorWithMagnitude)& Vec = (Handle(Geom_VectorWithMagnitude)&) Geometry;
    return MgtGeom::Translate (Vec);
  }
  else {
    Standard_NullObject::Raise("No mapping for the current Transient Geometry");
  }

  Handle(PGeom_Surface) dummy;
  return dummy;
}
