/* MA1HER.f -- translated by f2c (version 19960827).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "Data_f2c.h"
#ifdef WNT
#include <ApproxF2var.h>
#else
#define __ApproxF2var_API
#endif

/* Subroutine */ __ApproxF2var_API int mma1her_(iordre, hermit, iercod)
const integer *iordre;
doublereal *hermit;
integer *iercod;
{
    /* System generated locals */
    integer hermit_dim1, hermit_offset;

    /* Local variables */
    static integer ibb;
    extern integer mnfndeb_();
    extern /* Subroutine */ int maermsg_(), mgenmsg_(), mgsomsg_();




/* < */
/* **NOTICE */
/*  THIS SOFTWARE IS THE PROPERTY OF CISIGRAPH. */
/*  THIS CODE MUST NOT BE DISTRIBUTED OR COPIED WITHOUT THE PRIOR */
/*  WRITTEN PERMISSION OF CISIGRAPH AND IS ONLY TO BE USED ON THE */
/*  SITE WHERE IT IS INSTALLED BY CISIGRAPH */
/* **NOTICE */

/* ********************************************************************** 
*/

/*     FONCTION : */
/*     ---------- */
/*     Calcul des 2*(IORDRE+1) polynomes d'Hermite de degre 2*IORDRE+1 */
/*     sur (-1,1) */

/*     MOTS CLES : */
/*     ----------- */
/*     TOUS, AB_SPECIFI::CONTRAINTE&, INTERPOLATION, &POLYNOME */

/*     ARGUMENTS D'ENTREE : */
/*     ------------------ */
/*     IORDRE: Ordre de contrainte. */
/*      = 0, Polynome d'interpolation a l'ordre C0 sur (-1,1). */
/*      = 1, Polynome d'interpolation a l'ordre C0 et C1 sur (-1,1). */
/*      = 2, Polynome d'interpolation a l'ordre C0, C1 et C2 sur (-1,1). 
*/

/*     ARGUMENTS DE SORTIE : */
/*     ------------------- */
/*     HERMIT: Table des 2*IORDRE+2 coeff. de chacun des 2*(IORDRE+1) */
/*             polynomes d'HERMITE. */
/*     IERCOD: Code d'erreur, */
/*      = 0, Ok */
/*      = 1, L'ordre de contrainte demande n'est pas gere ici. */
/*     COMMONS UTILISES   : */
/*     ---------------- */

/*     REFERENCES APPELEES   : */
/*     ----------------------- */

/*     DESCRIPTION/REMARQUES/LIMITATIONS : */
/*     ----------------------------------- */
/*     La partie du tableau HERMIT(*,2*i+j) ou j=1 ou 2 et i=0 a IORDRE, 
*/
/*     contient les coefficients du polynome de degre 2*IORDRE+1 */
/*     tel que TOUTES les valeurs en -1 et en +1 de ce polynome et de */
/*     ses derivees jusqu'a l'ordre de derivation IORDRE sont NULLES, */
/*     SAUF la derivee d'ordre i: */
/*        - qui vaut 1 en -1 si j=1 */
/*        - qui vaut 1 en +1 si j=2. */

/* $    HISTORIQUE DES MODIFICATIONS   : */
/*     -------------------------------- */
/*     02-07-1991: RBD; Creation. */
/* > */
/* ********************************************************************** 
*/

/*   Le nom de la routine */


    /* Parameter adjustments */
    hermit_dim1 = (*iordre + 1) << 1;
    hermit_offset = hermit_dim1 + 1;
    hermit -= hermit_offset;

    /* Function Body */
    ibb = mnfndeb_();
    if (ibb >= 3) {
	mgenmsg_("MMA1HER", 7L);
    }
    *iercod = 0;

/* --- Recup des (IORDRE+2) coeff des 2*(IORDRE+1) polynomes d'Hermite -- 
*/

    if (*iordre == 0) {
	hermit[hermit_dim1 + 1] = .5;
	hermit[hermit_dim1 + 2] = -.5;

	hermit[(hermit_dim1 << 1) + 1] = .5;
	hermit[(hermit_dim1 << 1) + 2] = .5;
    } else if (*iordre == 1) {
	hermit[hermit_dim1 + 1] = .5;
	hermit[hermit_dim1 + 2] = -.75;
	hermit[hermit_dim1 + 3] = 0.;
	hermit[hermit_dim1 + 4] = .25;

	hermit[(hermit_dim1 << 1) + 1] = .5;
	hermit[(hermit_dim1 << 1) + 2] = .75;
	hermit[(hermit_dim1 << 1) + 3] = 0.;
	hermit[(hermit_dim1 << 1) + 4] = -.25;

	hermit[hermit_dim1 * 3 + 1] = .25;
	hermit[hermit_dim1 * 3 + 2] = -.25;
	hermit[hermit_dim1 * 3 + 3] = -.25;
	hermit[hermit_dim1 * 3 + 4] = .25;

	hermit[(hermit_dim1 << 2) + 1] = -.25;
	hermit[(hermit_dim1 << 2) + 2] = -.25;
	hermit[(hermit_dim1 << 2) + 3] = .25;
	hermit[(hermit_dim1 << 2) + 4] = .25;
    } else if (*iordre == 2) {
	hermit[hermit_dim1 + 1] = .5;
	hermit[hermit_dim1 + 2] = -.9375;
	hermit[hermit_dim1 + 3] = 0.;
	hermit[hermit_dim1 + 4] = .625;
	hermit[hermit_dim1 + 5] = 0.;
	hermit[hermit_dim1 + 6] = -.1875;

	hermit[(hermit_dim1 << 1) + 1] = .5;
	hermit[(hermit_dim1 << 1) + 2] = .9375;
	hermit[(hermit_dim1 << 1) + 3] = 0.;
	hermit[(hermit_dim1 << 1) + 4] = -.625;
	hermit[(hermit_dim1 << 1) + 5] = 0.;
	hermit[(hermit_dim1 << 1) + 6] = .1875;

	hermit[hermit_dim1 * 3 + 1] = .3125;
	hermit[hermit_dim1 * 3 + 2] = -.4375;
	hermit[hermit_dim1 * 3 + 3] = -.375;
	hermit[hermit_dim1 * 3 + 4] = .625;
	hermit[hermit_dim1 * 3 + 5] = .0625;
	hermit[hermit_dim1 * 3 + 6] = -.1875;

	hermit[(hermit_dim1 << 2) + 1] = -.3125;
	hermit[(hermit_dim1 << 2) + 2] = -.4375;
	hermit[(hermit_dim1 << 2) + 3] = .375;
	hermit[(hermit_dim1 << 2) + 4] = .625;
	hermit[(hermit_dim1 << 2) + 5] = -.0625;
	hermit[(hermit_dim1 << 2) + 6] = -.1875;

	hermit[hermit_dim1 * 5 + 1] = .0625;
	hermit[hermit_dim1 * 5 + 2] = -.0625;
	hermit[hermit_dim1 * 5 + 3] = -.125;
	hermit[hermit_dim1 * 5 + 4] = .125;
	hermit[hermit_dim1 * 5 + 5] = .0625;
	hermit[hermit_dim1 * 5 + 6] = -.0625;

	hermit[hermit_dim1 * 6 + 1] = .0625;
	hermit[hermit_dim1 * 6 + 2] = .0625;
	hermit[hermit_dim1 * 6 + 3] = -.125;
	hermit[hermit_dim1 * 6 + 4] = -.125;
	hermit[hermit_dim1 * 6 + 5] = .0625;
	hermit[hermit_dim1 * 6 + 6] = .0625;
    } else {
	*iercod = 1;
    }

/* ------------------------------ The End ------------------------------- 
*/

    maermsg_("MMA1HER", iercod, 7L);
    if (ibb >= 3) {
	mgsomsg_("MMA1HER", 7L);
    }
    return 0;
} /* mma1her_ */

