// File generated by CPPExt (Storable)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _gp_Elips_HeaderFile
#define _gp_Elips_HeaderFile

#ifndef _gp_Ax2_HeaderFile
#include <gp_Ax2.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Storable_HeaderFile
#include <Standard_Storable.hxx>
#endif
#ifndef _gp_Ax1_HeaderFile
#include <gp_Ax1.hxx>
#endif
#ifndef _gp_Pnt_HeaderFile
#include <gp_Pnt.hxx>
#endif
#ifndef _Standard_PrimitiveTypes_HeaderFile
#include <Standard_PrimitiveTypes.hxx>
#endif
class Standard_ConstructionError;
class gp_Ax2;
class gp_Ax1;
class gp_Pnt;
class gp_Trsf;
class gp_Vec;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

Standard_EXPORT Handle_Standard_Type& gp_Elips_Type_();


//!      Describes an ellipse in 3D space. <br>
//! An ellipse is defined by its major and minor radii and <br>
//! positioned in space with a coordinate system (a gp_Ax2 object) as follows: <br>
//! -   the origin of the coordinate system is the center of the ellipse, <br>
//! -   its "X Direction" defines the major axis of the ellipse, and <br>
//! - its "Y Direction" defines the minor axis of the ellipse. <br>
//! Together, the origin, "X Direction" and "Y Direction" of <br>
//! this coordinate system define the plane of the ellipse. <br>
//! This coordinate system is the "local coordinate system" <br>
//! of the ellipse. In this coordinate system, the equation of <br>
//! the ellipse is: <br>
//! X*X / (MajorRadius**2) + Y*Y / (MinorRadius**2) = 1.0 <br>
//! The "main Direction" of the local coordinate system gives <br>
//! the normal vector to the plane of the ellipse. This vector <br>
//! gives an implicit orientation to the ellipse (definition of the <br>
//! trigonometric sense). We refer to the "main Axis" of the <br>
//! local coordinate system as the "Axis" of the ellipse. <br>
//! See Also <br>
//! gce_MakeElips which provides functions for more <br>
//! complex ellipse constructions <br>
//! Geom_Ellipse which provides additional functions for <br>
//! constructing ellipses and works, in particular, with the <br>
//! parametric equations of ellipses <br>
class gp_Elips  {

public:
    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }

 // Methods PUBLIC
 // 
//! Creates an indefinite ellipse. <br>
gp_Elips();

//!  The major radius of the ellipse is on the "XAxis" and the <br>
//!  minor radius is on the "YAxis" of the ellipse. The "XAxis" <br>
//!  is defined with the "XDirection" of A2 and the "YAxis" is <br>
//!  defined with the "YDirection" of A2. <br>
//! Warnings : <br>
//!  It is not forbidden to create an ellipse with MajorRadius = <br>
//!  MinorRadius. <br>
//!  Raises ConstructionError if MajorRadius < MinorRadius or MinorRadius < 0. <br>
gp_Elips(const gp_Ax2& A2,const Standard_Real MajorRadius,const Standard_Real MinorRadius);

//!  Changes the axis normal to the plane of the ellipse. <br>
//!  It modifies the definition of this plane. <br>
//!  The "XAxis" and the "YAxis" are recomputed. <br>
//! The local coordinate system is redefined so that: <br>
//! -   its origin and "main Direction" become those of the <br>
//!   axis A1 (the "X Direction" and "Y Direction" are then <br>
//!   recomputed in the same way as for any gp_Ax2), or <br>
//!  Raises ConstructionError if the direction of A1 <br>
//! is parallel to the direction of the "XAxis" of the ellipse. <br>
  void SetAxis(const gp_Ax1& A1) ;
//!Modifies this ellipse, by redefining its local coordinate <br>
//! so that its origin becomes P. <br>
  void SetLocation(const gp_Pnt& P) ;

//!  The major radius of the ellipse is on the "XAxis" (major axis) <br>
//!  of the ellipse. <br>
//!  Raises ConstructionError if MajorRadius < MinorRadius. <br>
  void SetMajorRadius(const Standard_Real MajorRadius) ;

//!  The minor radius of the ellipse is on the "YAxis" (minor axis) <br>
//!  of the ellipse. <br>
//!  Raises ConstructionError if MinorRadius > MajorRadius or MinorRadius < 0. <br>
  void SetMinorRadius(const Standard_Real MinorRadius) ;
//! Modifies this ellipse, by redefining its local coordinate <br>
//! so that it becomes A2e. <br>
  void SetPosition(const gp_Ax2& A2) ;
//! Computes the area of the Ellipse. <br>
  Standard_Real Area() const;

//!  Computes the axis normal to the plane of the ellipse. <br>
 const gp_Ax1& Axis() const;
//! Computes the first or second directrix of this ellipse. <br>
//! These are the lines, in the plane of the ellipse, normal to <br>
//! the major axis, at a distance equal to <br>
//! MajorRadius/e from the center of the ellipse, where <br>
//! e is the eccentricity of the ellipse. <br>
//! The first directrix (Directrix1) is on the positive side of <br>
//! the major axis. The second directrix (Directrix2) is on <br>
//! the negative side. <br>
//! The directrix is returned as an axis (gp_Ax1 object), the <br>
//! origin of which is situated on the "X Axis" of the local <br>
//! coordinate system of this ellipse. <br>
//! Exceptions <br>
//! Standard_ConstructionError if the eccentricity is null <br>
//! (the ellipse has degenerated into a circle). <br>
  gp_Ax1 Directrix1() const;

//!  This line is obtained by the symmetrical transformation <br>
//!  of "Directrix1" with respect to the "YAxis" of the ellipse. <br>
//! Exceptions <br>
//! Standard_ConstructionError if the eccentricity is null <br>
//! (the ellipse has degenerated into a circle). <br>
  gp_Ax1 Directrix2() const;

//!  Returns the eccentricity of the ellipse  between 0.0 and 1.0 <br>
//!  If f is the distance between the center of the ellipse and <br>
//!  the Focus1 then the eccentricity e = f / MajorRadius. <br>
//!   Raises ConstructionError if MajorRadius = 0.0 <br>
  Standard_Real Eccentricity() const;

//!  Computes the focal distance. It is the distance between the <br>
//!  two focus focus1 and focus2 of the ellipse. <br>
  Standard_Real Focal() const;

//!  Returns the first focus of the ellipse. This focus is on the <br>
//!  positive side of the "XAxis" of the ellipse. <br>
  gp_Pnt Focus1() const;

//!  Returns the second focus of the ellipse. This focus is on the <br>
//!  negative side of the "XAxis" of the ellipse. <br>
  gp_Pnt Focus2() const;

//!  Returns the center of the ellipse. It is the "Location" <br>
//!  point of the coordinate system of the ellipse. <br>
 const gp_Pnt& Location() const;
//! Returns the major radius of the ellipse. <br>
  Standard_Real MajorRadius() const;
//! Returns the minor radius of the ellipse. <br>
  Standard_Real MinorRadius() const;

//!  Returns p = (1 - e * e) * MajorRadius where e is the eccentricity <br>
//!  of the ellipse. <br>
//!  Returns 0 if MajorRadius = 0 <br>
  Standard_Real Parameter() const;
//! Returns the coordinate system of the ellipse. <br>
 const gp_Ax2& Position() const;

//!  Returns the "XAxis" of the ellipse whose origin <br>
//! is the center of this ellipse. It is the major axis of the <br>
//!  ellipse. <br>
  gp_Ax1 XAxis() const;

//!  Returns the "YAxis" of the ellipse whose unit vector is the "X Direction" or the "Y Direction" <br>
//!  of the local coordinate system of this ellipse. <br>
//! This is the minor axis of the ellipse. <br>
  gp_Ax1 YAxis() const;


Standard_EXPORT   void Mirror(const gp_Pnt& P) ;


//!  Performs the symmetrical transformation of an ellipse with <br>
//!  respect to the point P which is the center of the symmetry. <br>
Standard_EXPORT   gp_Elips Mirrored(const gp_Pnt& P) const;


Standard_EXPORT   void Mirror(const gp_Ax1& A1) ;


//!  Performs the symmetrical transformation of an ellipse with <br>
//!  respect to an axis placement which is the axis of the symmetry. <br>
Standard_EXPORT   gp_Elips Mirrored(const gp_Ax1& A1) const;


Standard_EXPORT   void Mirror(const gp_Ax2& A2) ;


//!  Performs the symmetrical transformation of an ellipse with <br>
//!  respect to a plane. The axis placement A2 locates the plane <br>
//!  of the symmetry (Location, XDirection, YDirection). <br>
Standard_EXPORT   gp_Elips Mirrored(const gp_Ax2& A2) const;

  void Rotate(const gp_Ax1& A1,const Standard_Real Ang) ;

//!  Rotates an ellipse. A1 is the axis of the rotation. <br>
//!  Ang is the angular value of the rotation in radians. <br>
  gp_Elips Rotated(const gp_Ax1& A1,const Standard_Real Ang) const;

  void Scale(const gp_Pnt& P,const Standard_Real S) ;

//!  Scales an ellipse. S is the scaling value. <br>
  gp_Elips Scaled(const gp_Pnt& P,const Standard_Real S) const;

  void Transform(const gp_Trsf& T) ;

//!  Transforms an ellipse with the transformation T from class Trsf. <br>
  gp_Elips Transformed(const gp_Trsf& T) const;

  void Translate(const gp_Vec& V) ;

//!  Translates an ellipse in the direction of the vector V. <br>
//!  The magnitude of the translation is the vector's magnitude. <br>
  gp_Elips Translated(const gp_Vec& V) const;

  void Translate(const gp_Pnt& P1,const gp_Pnt& P2) ;

//!  Translates an ellipse from the point P1 to the point P2. <br>
  gp_Elips Translated(const gp_Pnt& P1,const gp_Pnt& P2) const;
    const gp_Ax2& _CSFDB_Getgp_Elipspos() const { return pos; }
    Standard_Real _CSFDB_Getgp_ElipsmajorRadius() const { return majorRadius; }
    void _CSFDB_Setgp_ElipsmajorRadius(const Standard_Real p) { majorRadius = p; }
    Standard_Real _CSFDB_Getgp_ElipsminorRadius() const { return minorRadius; }
    void _CSFDB_Setgp_ElipsminorRadius(const Standard_Real p) { minorRadius = p; }




 // Type management
 //
 Standard_EXPORT friend Handle_Standard_Type& gp_Elips_Type_();

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
gp_Ax2 pos;
Standard_Real majorRadius;
Standard_Real minorRadius;


};


#include <gp_Elips.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
