// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _WOKNT_MixedOutput_HeaderFile
#define _WOKNT_MixedOutput_HeaderFile

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_TColStd_HSequenceOfHAsciiString_HeaderFile
#include <Handle_TColStd_HSequenceOfHAsciiString.hxx>
#endif
#ifndef _WOKNT_ShellOutput_HeaderFile
#include <WOKNT_ShellOutput.hxx>
#endif
class TColStd_HSequenceOfHAsciiString;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! manages output of sub-process ( creates a pipe ). <br>
//!          Standard output stream and standard error stream are MIXED. <br>
class WOKNT_MixedOutput  : public WOKNT_ShellOutput {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! creates a class instance <br>
Standard_EXPORT WOKNT_MixedOutput();

//! dummy method to be used in derived class <br>
Standard_EXPORT virtual  void Cleanup() ;
~WOKNT_MixedOutput()
{
  Cleanup();
}


//! creates a pipe for reading a standard output of sub-process <br>
//!          and returns a pipe handle. <br>
//!  Warning: returns INVALID_HANDLE_VALUE in case of failure <br>
Standard_EXPORT   Standard_Integer OpenStdOut() ;

//! closes write end of the 'STDOUT' pipe <br>
Standard_EXPORT   void CloseStdOut() ;

//! creates a pipe for reading a standard error output of sub-process <br>
//!          and returns a pipe handle <br>
//!  Warning: this method is simply calling 'OpenStdOut' method <br>
Standard_EXPORT virtual  Standard_Integer OpenStdErr() ;

//! closes write end of the 'STDERR' pipe <br>
//!  Warning: this method is simply calling 'CloseStdOut' method <br>
Standard_EXPORT virtual  void CloseStdErr() ;

//! clears output buffer of sub-process <br>
Standard_EXPORT virtual  void Clear() ;

//! returns standard output of sub-process <br>
//!  Warning: returns NULL object if there is nothing to read <br>
Standard_EXPORT   Handle_TColStd_HSequenceOfHAsciiString Echo() ;

//! returns standard error output of sub-process <br>
//!  Warning: this method is simply calling 'Echo' method <br>
Standard_EXPORT virtual  Handle_TColStd_HSequenceOfHAsciiString Errors() ;

//! waits for sub-process termination ( until the write end of pipe <br>
//!          will be closed ). <br>
//!  Warning: write end of pipe MUST BE CLOSED by parent process immediately <br>
//!          after creation of the child process else this method will <br>
//!          NEVER return. Use ONLY 'CloseStdOut' method for this purpose. <br>
Standard_EXPORT   Handle_TColStd_HSequenceOfHAsciiString SyncStdOut() ;

//! same as 'SyncStdOut' method <br>
//!  Warning: use 'CloseStdErr' method to close write end of pipe <br>
Standard_EXPORT virtual  Handle_TColStd_HSequenceOfHAsciiString SyncStdErr() ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //
Standard_Integer myOutHandle;
Handle_TColStd_HSequenceOfHAsciiString myStdOut;


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
