// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Vrml_PointLight_HeaderFile
#define _Vrml_PointLight_HeaderFile

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Quantity_Color_HeaderFile
#include <Quantity_Color.hxx>
#endif
#ifndef _gp_Vec_HeaderFile
#include <gp_Vec.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
class Quantity_Color;
class gp_Vec;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//!defines a point  light node of VRML specifying <br>
//!         properties of lights. <br>
//!  This  node  defines  a  point  light  source   at  a  fixed  3D  location <br>
//!  A  point  source  illuminates equally  in  all  directions; <br>
//!  that  is  omni-directional. <br>
//!  Color is  written  as  an  RGB  triple. <br>
//!  Light intensity must be in the range 0.0 to 1.0, inclusive. <br>
class Vrml_PointLight  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT Vrml_PointLight();


Standard_EXPORT Vrml_PointLight(const Standard_Boolean aOnOff,const Standard_Real aIntensity,const Quantity_Color& aColor,const gp_Vec& aLocation);


Standard_EXPORT   void SetOnOff(const Standard_Boolean aOnOff) ;


Standard_EXPORT   Standard_Boolean OnOff() const;


Standard_EXPORT   void SetIntensity(const Standard_Real aIntensity) ;


Standard_EXPORT   Standard_Real Intensity() const;


Standard_EXPORT   void SetColor(const Quantity_Color& aColor) ;


Standard_EXPORT   Quantity_Color Color() const;


Standard_EXPORT   void SetLocation(const gp_Vec& aLocation) ;


Standard_EXPORT   gp_Vec Location() const;


Standard_EXPORT   Standard_OStream& Print(Standard_OStream& anOStream) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Boolean myOnOff;
Standard_Real myIntensity;
Quantity_Color myColor;
gp_Vec myLocation;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
