// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _VrmlConverter_Curve_HeaderFile
#define _VrmlConverter_Curve_HeaderFile

#ifndef _Handle_VrmlConverter_Drawer_HeaderFile
#include <Handle_VrmlConverter_Drawer.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
class Adaptor3d_Curve;
class VrmlConverter_Drawer;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Curve - computes the presentation of objects to be <br>
//!          seen  as curves  (the  computation  will  be  made <br>
//!          with a constant  number  of  points),  converts this one <br>
//!          into  VRML  objects  and  writes (adds) them  into <br>
//!          anOStream.   All  requested   properties  of   the <br>
//!          representation are specify  in aDrawer  of  Drawer <br>
//!          class (VrmlConverter). <br>
//!          This kind of the presentation is converted into <br>
//!          IndexedLineSet ( VRML ). <br>
class VrmlConverter_Curve  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! adds to the OStream the drawing of the curve aCurve. <br>
//!          The aspect is defined by LineAspect in aDrawer. <br>
//! <br>
Standard_EXPORT static  void Add(const Adaptor3d_Curve& aCurve,const Handle(VrmlConverter_Drawer)& aDrawer,Standard_OStream& anOStream) ;

//! adds to the OStream the drawing of the curve aCurve. <br>
//!          The aspect is defined by LineAspect in aDrawer. <br>
//!          The drawing will be limited between the points of parameter <br>
//!          U1 and U2. <br>
Standard_EXPORT static  void Add(const Adaptor3d_Curve& aCurve,const Standard_Real U1,const Standard_Real U2,const Handle(VrmlConverter_Drawer)& aDrawer,Standard_OStream& anOStream) ;

//! adds to the OStream the drawing of the curve aCurve. <br>
//!          The aspect is the current aspect. <br>
//!          The drawing will be limited between the points of parameter <br>
//!          U1 and U2. aNbPoints defines  number of points on  one interval. <br>
Standard_EXPORT static  void Add(const Adaptor3d_Curve& aCurve,const Standard_Real U1,const Standard_Real U2,Standard_OStream& anOStream,const Standard_Integer aNbPoints) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
