// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _TDataStd_ChildNodeIterator_HeaderFile
#define _TDataStd_ChildNodeIterator_HeaderFile

#ifndef _Handle_TDataStd_TreeNode_HeaderFile
#include <Handle_TDataStd_TreeNode.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class TDataStd_TreeNode;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//!  Iterates on the  ChildStepren step of  a step, at the <br>
//!           first level  only.   It  is possible  to ask  the <br>
//!          iterator to explore all the sub step levels of the <br>
//!          given one, with the option "allLevels". <br>
class TDataStd_ChildNodeIterator  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Creates an empty iterator. <br>
Standard_EXPORT TDataStd_ChildNodeIterator();

//! Iterates on the ChildStepren of the given Step. If <br>
//!          <allLevels> option is set to true, it explores not <br>
//!          only the first, but all the sub Step levels. <br>
Standard_EXPORT TDataStd_ChildNodeIterator(const Handle(TDataStd_TreeNode)& aTreeNode,const Standard_Boolean allLevels = Standard_False);

//! Initializes the iteration on  the Children Step of <br>
//!          the  given Step. If <allLevels>  option is  set to <br>
//!          true, it explores not  only the first, but all the <br>
//!          sub Step levels. <br>
Standard_EXPORT   void Initialize(const Handle(TDataStd_TreeNode)& aTreeNode,const Standard_Boolean allLevels = Standard_False) ;
//! Returns True if there is a current Item in the <br>
//!          iteration. <br>
  Standard_Boolean More() const;

//! Move to the next Item <br>
Standard_EXPORT   void Next() ;

//! Move to the next Brother. If there is none, go up <br>
//!          etc. This method is interesting only with <br>
//!          "allLevels" behavior, because it avoids to explore <br>
//!          the current Step ChildStepren. <br>
Standard_EXPORT   void NextBrother() ;
//! Returns the current item; a null Step if there is <br>
//!          no one. <br>
  Handle_TDataStd_TreeNode Value() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_TDataStd_TreeNode myNode;
Standard_Integer myFirstLevel;


};


#include <TDataStd_ChildNodeIterator.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
