// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _ShapeFix_Root_HeaderFile
#define _ShapeFix_Root_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_ShapeFix_Root_HeaderFile
#include <Handle_ShapeFix_Root.hxx>
#endif

#ifndef _Handle_ShapeBuild_ReShape_HeaderFile
#include <Handle_ShapeBuild_ReShape.hxx>
#endif
#ifndef _Handle_ShapeExtend_BasicMsgRegistrator_HeaderFile
#include <Handle_ShapeExtend_BasicMsgRegistrator.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _TopoDS_Shape_HeaderFile
#include <TopoDS_Shape.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _Message_Gravity_HeaderFile
#include <Message_Gravity.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
class ShapeBuild_ReShape;
class ShapeExtend_BasicMsgRegistrator;
class TopoDS_Shape;
class Message_Msg;


//! Root class for fixing operations <br>
//!          Provides context for recording changes (optional), <br>
//!          basic precision value and limit (minimal and <br>
//!          maximal) values for tolerances, <br>
//!          and message registrator <br>
class ShapeFix_Root : public MMgt_TShared {

public:
 // Methods PUBLIC
 // 

//! Empty Constructor (no context is created) <br>
Standard_EXPORT ShapeFix_Root();

//! Copy all fields from another Root object <br>
Standard_EXPORT virtual  void Set(const Handle(ShapeFix_Root)& Root) ;

//! Sets context <br>
Standard_EXPORT virtual  void SetContext(const Handle(ShapeBuild_ReShape)& context) ;
//! Returns context <br>
  Handle_ShapeBuild_ReShape Context() const;

//! Sets message registrator <br>
Standard_EXPORT virtual  void SetMsgRegistrator(const Handle(ShapeExtend_BasicMsgRegistrator)& msgreg) ;
//! Returns message registrator <br>
  Handle_ShapeExtend_BasicMsgRegistrator MsgRegistrator() const;

//! Sets basic precision value <br>
Standard_EXPORT virtual  void SetPrecision(const Standard_Real preci) ;
//! Returns basic precision value <br>
  Standard_Real Precision() const;

//! Sets minimal allowed tolerance <br>
Standard_EXPORT virtual  void SetMinTolerance(const Standard_Real mintol) ;
//! Returns minimal allowed tolerance <br>
  Standard_Real MinTolerance() const;

//! Sets maximal allowed tolerance <br>
Standard_EXPORT virtual  void SetMaxTolerance(const Standard_Real maxtol) ;
//! Returns maximal allowed tolerance <br>
  Standard_Real MaxTolerance() const;
//! Returns tolerance limited by [myMinTol,myMaxTol] <br>
  Standard_Real LimitTolerance(const Standard_Real toler) const;

//! Sends a message to be attached to the shape. <br>
//!          Calls corresponding message of message registrator. <br>
Standard_EXPORT   void SendMsg(const TopoDS_Shape& shape,const Message_Msg& message,const Message_Gravity gravity = Message_INFO) const;
//! Sends a message to be attached to myShape. <br>
//!          Calls previous method. <br>
  void SendMsg(const Message_Msg& message,const Message_Gravity gravity = Message_INFO) const;
//! Sends a warning to be attached to the shape. <br>
//!          Calls SendMsg with gravity set to Message_WARNING. <br>
  void SendWarning(const TopoDS_Shape& shape,const Message_Msg& message) const;
//! Calls previous method for myShape. <br>
  void SendWarning(const Message_Msg& message) const;
//! Sends a fail to be attached to the shape. <br>
//!          Calls SendMsg with gravity set to Message_FAIL. <br>
  void SendFail(const TopoDS_Shape& shape,const Message_Msg& message) const;
//! Calls previous method for myShape. <br>
  void SendFail(const Message_Msg& message) const;
//Standard_EXPORT ~ShapeFix_Root();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 
//! Auxiliary method for work with three-position <br>
//!          (on/off/default) flags (modes) in ShapeFix. <br>
static  Standard_Boolean NeedFix(const Standard_Integer flag,const Standard_Boolean def = Standard_True) ;


 // Fields PROTECTED
 //
TopoDS_Shape myShape;


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_ShapeBuild_ReShape myContext;
Handle_ShapeExtend_BasicMsgRegistrator myMsgReg;
Standard_Real myPrecision;
Standard_Real myMinTol;
Standard_Real myMaxTol;


};


#include <ShapeFix_Root.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
