// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Geom_BoundedCurve_HeaderFile
#define _Geom_BoundedCurve_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_Geom_BoundedCurve_HeaderFile
#include <Handle_Geom_BoundedCurve.hxx>
#endif

#ifndef _Geom_Curve_HeaderFile
#include <Geom_Curve.hxx>
#endif
class gp_Pnt;


//! The abstract class BoundedCurve describes the <br>
//! common behavior of bounded curves in 3D space. A <br>
//! bounded curve is limited by two finite values of the <br>
//! parameter, termed respectively "first parameter" and <br>
//! "last parameter". The "first parameter" gives the "start <br>
//! point" of the bounded curve, and the "last parameter" <br>
//! gives the "end point" of the bounded curve. <br>
//! The length of a bounded curve is finite. <br>
//! The Geom package provides three concrete classes of bounded curves: <br>
//! - two frequently used mathematical formulations of complex curves: <br>
//!   - Geom_BezierCurve, <br>
//!   - Geom_BSplineCurve, and <br>
//! - Geom_TrimmedCurve to trim a curve, i.e. to only <br>
//!   take part of the curve limited by two values of the <br>
//!   parameter of the basis curve. <br>
class Geom_BoundedCurve : public Geom_Curve {

public:
 // Methods PUBLIC
 // 

//! Returns the end point of the curve. <br>
Standard_EXPORT virtual  gp_Pnt EndPoint() const = 0;

//! Returns the start point of the curve. <br>
Standard_EXPORT virtual  gp_Pnt StartPoint() const = 0;
//Standard_EXPORT ~Geom_BoundedCurve();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
