// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Extrema_FuncExtPS_HeaderFile
#define _Extrema_FuncExtPS_HeaderFile

#ifndef _gp_Pnt_HeaderFile
#include <gp_Pnt.hxx>
#endif
#ifndef _Adaptor3d_SurfacePtr_HeaderFile
#include <Adaptor3d_SurfacePtr.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _TColStd_SequenceOfReal_HeaderFile
#include <TColStd_SequenceOfReal.hxx>
#endif
#ifndef _Extrema_SequenceOfPOnSurf_HeaderFile
#include <Extrema_SequenceOfPOnSurf.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _math_FunctionSetWithDerivatives_HeaderFile
#include <math_FunctionSetWithDerivatives.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
class Standard_OutOfRange;
class gp_Pnt;
class Adaptor3d_Surface;
class math_Vector;
class math_Matrix;
class Extrema_POnSurf;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Fonction permettant de rechercher les extrema de la <br>
//!          distance entre un point et une surface. <br>
class Extrema_FuncExtPS  : public math_FunctionSetWithDerivatives {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT Extrema_FuncExtPS();


Standard_EXPORT Extrema_FuncExtPS(const gp_Pnt& P,const Adaptor3d_Surface& S);

//! sets the field mysurf of the function. <br>
Standard_EXPORT   void Initialize(const Adaptor3d_Surface& S) ;

//! sets the field mysurf of the function. <br>
Standard_EXPORT   void SetPoint(const gp_Pnt& P) ;


Standard_EXPORT   Standard_Integer NbVariables() const;


Standard_EXPORT   Standard_Integer NbEquations() const;

//! Calcul de Fi(U,V). <br>
Standard_EXPORT   Standard_Boolean Value(const math_Vector& UV,math_Vector& F) ;

//! Calcul de Fi'(U,V). <br>
Standard_EXPORT   Standard_Boolean Derivatives(const math_Vector& UV,math_Matrix& DF) ;

//! Calcul de Fi(U,V) et Fi'(U,V). <br>
Standard_EXPORT   Standard_Boolean Values(const math_Vector& UV,math_Vector& F,math_Matrix& DF) ;

//! Memorise l'extremum trouve. <br>
Standard_EXPORT virtual  Standard_Integer GetStateNumber() ;

//! Renvoie le nombre d'extrema trouves. <br>
Standard_EXPORT   Standard_Integer NbExt() const;

//! Renvoie la valeur de la Nieme distance. <br>
Standard_EXPORT   Standard_Real Value(const Standard_Integer N) const;

//! Renvoie le Nieme extremum. <br>
Standard_EXPORT   Extrema_POnSurf Point(const Standard_Integer N) const;


Standard_EXPORT   Standard_Boolean HasDegIso() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


Standard_EXPORT   Adaptor3d_SurfacePtr Bidon() const;


 // Fields PRIVATE
 //
gp_Pnt myP;
Adaptor3d_SurfacePtr myS;
Standard_Real myU;
Standard_Real myV;
gp_Pnt myPs;
TColStd_SequenceOfReal myValue;
Extrema_SequenceOfPOnSurf myPoint;
Standard_Boolean myPinit;
Standard_Boolean mySinit;
Standard_Boolean myUIsoIsDeg;
Standard_Boolean myVIsoIsDeg;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
