// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BRepFill_TrimSurfaceTool_HeaderFile
#define _BRepFill_TrimSurfaceTool_HeaderFile

#ifndef _TopoDS_Face_HeaderFile
#include <TopoDS_Face.hxx>
#endif
#ifndef _TopoDS_Edge_HeaderFile
#include <TopoDS_Edge.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_Geom2d_Curve_HeaderFile
#include <Handle_Geom2d_Curve.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Handle_Geom_Curve_HeaderFile
#include <Handle_Geom_Curve.hxx>
#endif
#ifndef _GeomAbs_Shape_HeaderFile
#include <GeomAbs_Shape.hxx>
#endif
class Geom2d_Curve;
class Standard_NoSuchObject;
class TopoDS_Face;
class TopoDS_Edge;
class TColgp_SequenceOfPnt;
class gp_Pnt2d;
class Geom_Curve;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


class BRepFill_TrimSurfaceTool  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT BRepFill_TrimSurfaceTool(const Handle(Geom2d_Curve)& Bis,const TopoDS_Face& Face1,const TopoDS_Face& Face2,const TopoDS_Edge& Edge1,const TopoDS_Edge& Edge2,const Standard_Boolean Inv1,const Standard_Boolean Inv2);

//! Intersect <Bis>  with the  projection of the edges <br>
//!          <EdgeOnFi> and returns the intersecting parameters <br>
//!          on Bis and on the edges <br>
//!          P.X() : Parameter on Bis <br>
//!          P.Y() : Parameter on EdgeOnF1 <br>
//!          P.Z() : Parameter on EdgeOnF2 <br>//! raises if <Edge> is not a edge of Face1 or Face2. <br>
Standard_EXPORT   void IntersectWith(const TopoDS_Edge& EdgeOnF1,const TopoDS_Edge& EdgeOnF2,TColgp_SequenceOfPnt& Points) const;

//! returns True if the Line (P, DZ) intersect the Faces <br>
Standard_EXPORT   Standard_Boolean IsOnFace(const gp_Pnt2d& Point) const;

//! returns the parameter of the  point <Point> on the <br>
//!          Edge <Edge>, assuming that the point is on the edge. <br>
Standard_EXPORT   Standard_Real ProjOn(const gp_Pnt2d& Point,const TopoDS_Edge& Edge) const;


Standard_EXPORT   void Project(const Standard_Real U1,const Standard_Real U2,Handle(Geom_Curve)& Curve,Handle(Geom2d_Curve)& PCurve1,Handle(Geom2d_Curve)& PCurve2,GeomAbs_Shape& myCont) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
TopoDS_Face myFace1;
TopoDS_Face myFace2;
TopoDS_Edge myEdge1;
TopoDS_Edge myEdge2;
Standard_Boolean myInv1;
Standard_Boolean myInv2;
Handle_Geom2d_Curve myBis;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
